/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Individuals.FitnessPackage.BasicFitness;
import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Genotype;
import Individuals.Individual;
import Individuals.Phenotype;
import Mapper.GEGrammar;
import Operator.Operations.RouletteWheel;
import Util.Random.MersenneTwisterFast;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import java.util.ArrayList;
import java.util.List;

public class ProportionalRouletteWheel
extends RouletteWheel
implements Stochastic {
    public ProportionalRouletteWheel(int size, RandomNumberGenerator rng) {
        super(size, rng);
    }

    public ProportionalRouletteWheel() {
    }

    @Override
    protected void calculateAccumulatedFitnessProbabilities(List<Individual> operands) {
        double tmp;
        int cnt;
        if (this.sumFit == 0.0) {
            return;
        }
        this.accProbs = new double[operands.size()];
        double[] tmpA = new double[this.accProbs.length];
        double tmpSum = 0.0;
        for (cnt = 0; cnt < operands.size(); ++cnt) {
            tmp = operands.get(cnt).getFitness().getDouble();
            if (this.smallFit) {
                tmp *= 1000.0;
            }
            tmpA[cnt] = tmp = 1.0 / (tmp + 1.0);
            tmpSum += tmp;
        }
        for (cnt = 0; cnt < operands.size(); ++cnt) {
            tmp = tmpA[cnt];
            this.accProbs[cnt] = cnt > 0 ? this.accProbs[cnt - 1] + tmp : (tmp /= tmpSum);
            if (!(this.accProbs[cnt] > 1.0)) continue;
            this.accProbs[cnt] = 1.0;
        }
    }

    public static void main(String[] args) {
        int runs = 1;
        ArrayList<Double> aL = new ArrayList<Double>(runs * 2);
        for (int ii = 0; ii < runs; ++ii) {
            int size = 2;
            MersenneTwisterFast rng = new MersenneTwisterFast();
            ProportionalRouletteWheel rws = new ProportionalRouletteWheel(size, rng);
            int popSize = 5;
            ArrayList<Individual> alI = new ArrayList<Individual>(popSize);
            String grammarFile = System.getProperty("user.dir") + "/param/Grammar/sf_grammar.bnf";
            GEGrammar gram = new GEGrammar(grammarFile);
            int maxChromSize = 10000;
            Phenotype phenotype = new Phenotype();
            Genotype genotype = new Genotype(1);
            GEChromosome chrom = new GEChromosome(maxChromSize);
            int[] codons = new int[maxChromSize];
            chrom.setAll(codons);
            genotype.add(chrom);
            gram.setPhenotype(phenotype);
            for (int i = 1; i < popSize; ++i) {
                GEIndividual ind = new GEIndividual();
                BasicFitness bf = new BasicFitness(i, ind);
                ind.setFitness(bf);
                ind.setMapper(gram);
                ind.setGenotype(genotype);
                ind.setPhenotype(phenotype);
                alI.add(ind);
            }
            rws.doOperation(alI);
            for (int k = 0; k < rws.selectedPopulation.size(); ++k) {
                aL.add(rws.selectedPopulation.get(k).getFitness().getDouble());
            }
            rws.selectedPopulation.clear();
        }
        StringBuffer s = new StringBuffer();
        for (Double anAL : aL) {
            s.append(anAL);
            s.append(" ");
        }
        s.append("\n");
        System.out.println(s.toString());
    }
}

