/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Exceptions.BadParameterException;
import FitnessEvaluation.FitnessFunction;
import Individuals.Individual;
import Operator.Operations.Operation;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import java.util.List;
import java.util.Properties;

public abstract class MutationOperation
implements Stochastic,
Operation {
    protected double probability;
    protected double noOfMutationCalls;
    protected RandomNumberGenerator rng;
    protected FitnessFunction fitnessFunction;

    public MutationOperation(double prob, RandomNumberGenerator rng) {
        this.probability = prob;
        this.rng = rng;
        this.noOfMutationCalls = 0.0;
    }

    public MutationOperation(RandomNumberGenerator rng, Properties p) {
        this.setProperties(p);
        this.rng = rng;
    }

    @Override
    public void setProperties(Properties p) {
        int generations;
        int popSize;
        double value;
        try {
            String key = "mutation_probability";
            value = Double.parseDouble(p.getProperty(key));
            if (value < 0.0 || value > 1.0) {
                throw new BadParameterException(key);
            }
        }
        catch (Exception e) {
            value = 0.01;
            System.out.println(e + " using default: " + value);
        }
        this.probability = value;
        try {
            String key = p.getProperty("population_size");
            popSize = Integer.parseInt(key);
        }
        catch (NumberFormatException e) {
            popSize = 0;
        }
        try {
            String key = p.getProperty("generations");
            generations = Integer.parseInt(key);
        }
        catch (NumberFormatException e) {
            generations = 0;
        }
        this.noOfMutationCalls = generations * popSize;
    }

    @Override
    public abstract void doOperation(Individual var1);

    @Override
    public abstract void doOperation(List<Individual> var1);

    public void setFitnessFunction(FitnessFunction ff) {
        this.fitnessFunction = ff;
    }

    @Override
    public void setRNG(RandomNumberGenerator m) {
        this.rng = m;
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.rng;
    }
}

