/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Fractal.GuiComp;
import Individuals.Individual;
import Operator.Operations.SelectionOperation;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class LSystemSelect
extends SelectionOperation
implements Stochastic {
    protected RandomNumberGenerator rng;
    List<Individual> parents = new LinkedList<Individual>();
    int generations = 0;
    int generation = 0;

    public LSystemSelect() {
    }

    public LSystemSelect(int size) {
        super(size);
    }

    @Override
    public void setProperties(Properties p) {
        super.setProperties(p);
        String value = p.getProperty("generations");
        try {
            this.generations = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            this.generations = 0;
        }
        p.setProperty("replacement_type", "generational");
        p.setProperty("elite_size", "0");
    }

    @Override
    public void doOperation(Individual operand) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doOperation(List<Individual> operands) {
        LinkedList<Individual> valids = new LinkedList<Individual>();
        String[] arrayPheno = new String[operands.size()];
        String[] arrayDepth = new String[operands.size()];
        String[] arrayAngle = new String[operands.size()];
        double[] arrayFitns = new double[operands.size()];
        int count = 0;
        StringBuffer outPop = new StringBuffer();
        for (Individual operand : operands) {
            if (!operand.isValid()) continue;
            valids.add(operand);
        }
        if (valids.size() == 0) {
            return;
        }
        while (valids.size() < operands.size()) {
            valids.add((Individual)valids.get(this.rng.nextInt(valids.size())));
        }
        for (Individual ind : valids) {
            arrayDepth[count] = ind.getPhenotype().getString().substring(0, 1);
            arrayAngle[count] = ind.getPhenotype().getString().substring(1, 6);
            arrayPheno[count] = ind.getPhenotype().getString().substring(6);
            arrayFitns[count] = ind.getFitness().getDouble();
            if (arrayPheno[count].length() > 200 && Integer.parseInt(arrayDepth[count]) > 3) {
                arrayDepth[count] = "3";
            }
            ++count;
        }
        GuiComp gui = new GuiComp(arrayPheno, arrayDepth, arrayAngle, arrayFitns, count, ++this.generation, this.generations);
        while (gui.stillRunning()) {
            try {
                GuiComp i$ = gui;
                synchronized (i$) {
                    gui.wait(1000L);
                }
            }
            catch (InterruptedException e) {
            }
        }
        int[] fitness = gui.getGELSYSFitness();
        gui.setVisible(false);
        gui.dispose();
        gui = null;
        if (fitness == null) {
            System.out.println("not working!");
        } else {
            int current = 0;
            String[] tempOut = new String[valids.size()];
            for (Individual ind : valids) {
                if (fitness[current] == 1) {
                    ind.getFitness().setDouble(ind.getFitness().getDouble() * 0.99);
                    this.selectedPopulation.add(ind.clone());
                    this.parents.add(ind);
                    tempOut[current] = ind.getPhenotype().toString();
                    outPop.append("\n");
                    outPop.append(ind.getPhenotype().toString());
                } else if (fitness[current] == 2) {
                    Iterator<Individual> itor = operands.iterator();
                    while (itor.hasNext()) {
                        Individual i = itor.next();
                        if (i != ind) continue;
                        itor.remove();
                    }
                }
                ++current;
            }
        }
        while (this.selectedPopulation.size() < 2) {
            this.selectedPopulation.add(((Individual)valids.get(this.rng.nextInt(valids.size()))).clone());
        }
        ArrayList<Individual> fillPop = new ArrayList<Individual>(this.selectedPopulation.getAll());
        while (this.selectedPopulation.size() < this.size) {
            this.selectedPopulation.add(((Individual)fillPop.get(this.rng.nextInt(fillPop.size()))).clone());
        }
    }

    @Override
    public void setRNG(RandomNumberGenerator m) {
        this.rng = m;
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.rng;
    }
}

