/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Individual;
import Operator.Operations.MutationOperation;
import Util.Random.RandomNumberGenerator;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class IntFlipFitness
extends MutationOperation {
    public IntFlipFitness(double prob, RandomNumberGenerator rng) {
        super(prob, rng);
    }

    public IntFlipFitness(RandomNumberGenerator rng, Properties p) {
        super(rng, p);
    }

    @Override
    public void doOperation(List<Individual> operands) {
        for (Individual operand : operands) {
            this.doOperation(operand);
        }
    }

    @Override
    public void doOperation(Individual operand) {
        this.doMutation(operand);
        ((GEIndividual)operand).invalidate();
    }

    private void doMutation(Individual operand) {
        GEChromosome c = (GEChromosome)operand.getGenotype().get(0);
        ((GEIndividual)operand).setMapped(false);
        operand.map(0);
        this.fitnessFunction.getFitness(operand);
        double fitnessBefore = operand.getFitness().getDouble();
        for (int i = 0; i < c.getLength(); ++i) {
            if (!this.rng.nextBoolean(this.probability)) continue;
            c.set(i, Math.abs(this.rng.nextInt()));
        }
        ((GEIndividual)operand).setMapped(false);
        operand.map(0);
        this.fitnessFunction.getFitness(operand);
        double fitnessAfter = operand.getFitness().getDouble();
        double fitnessChange = 0.0;
        int fitnessImprovement = 0;
        if (fitnessAfter != 1.0E8 && fitnessBefore != 1.0E8) {
            fitnessImprovement = fitnessBefore < fitnessAfter ? -1 : (fitnessBefore > fitnessAfter ? 1 : 0);
            fitnessChange = Math.abs(fitnessBefore - fitnessAfter);
        } else if (fitnessAfter == 1.0E8) {
            fitnessChange = 0.0;
            fitnessImprovement = -2;
        } else if (fitnessBefore == 1.0E8) {
            fitnessChange = 0.0;
            fitnessImprovement = -3;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter("intflipFitnessChanges.dat", true));
            out.write(String.valueOf(fitnessChange) + ", " + String.valueOf(fitnessImprovement));
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

