/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Individual;
import Operator.Operations.MutationOperation;
import Util.Random.RandomNumberGenerator;
import java.util.List;
import java.util.Properties;

public class IntFlipByteMutation
extends MutationOperation {
    public IntFlipByteMutation(double prob, RandomNumberGenerator rng) {
        super(prob, rng);
    }

    public IntFlipByteMutation(RandomNumberGenerator rng, Properties p) {
        super(rng, p);
    }

    @Override
    public void doOperation(List<Individual> operands) {
        for (Individual operand : operands) {
            this.doOperation(operand);
        }
    }

    @Override
    public void doOperation(Individual operand) {
        this.doMutation((GEChromosome)operand.getGenotype().get(0));
        ((GEIndividual)operand).invalidate();
    }

    private void doMutation(GEChromosome c) {
        for (int i = 0; i < c.getLength(); ++i) {
            int mut = 0;
            for (int ii = 0; ii < c.getCodonSize(); ++ii) {
                for (int j = 0; j < 8; ++j) {
                    if (!this.rng.nextBoolean(this.probability)) continue;
                    mut += (int)Math.pow(2.0, j * (ii + 1));
                }
            }
            c.set(i, c.get(i) ^ mut);
        }
    }
}

