/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Exceptions.BadParameterException;
import Exceptions.InitializationException;
import Individuals.FitnessPackage.BasicFitness;
import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Genotype;
import Individuals.Individual;
import Individuals.Phenotype;
import Mapper.GEGrammar;
import Mapper.Production;
import Mapper.Rule;
import Mapper.Symbol;
import Operator.Operations.CreationOperation;
import Util.Constants;
import Util.Enums;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import Util.Structures.NimbleTree;
import Util.Structures.TreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class GrowInitialiser
implements CreationOperation,
Stochastic {
    protected Genotype genotype;
    protected GEChromosome chromosome;
    protected RandomNumberGenerator rng;
    protected int maxDepth;
    protected int minDepth;
    protected GEGrammar grammar;
    protected int initChromSize;
    private double tailSize;

    public GrowInitialiser(RandomNumberGenerator rng, GEGrammar gegrammar, int maxDepth) {
        this.grammar = gegrammar;
        this.maxDepth = maxDepth;
        this.minDepth = 0;
        this.initChromSize = 100;
        this.rng = rng;
    }

    public GrowInitialiser(RandomNumberGenerator rng, GEGrammar gegrammar, Properties p) {
        this.grammar = gegrammar;
        this.initChromSize = 100;
        this.setProperties(p);
        this.minDepth = 0;
        this.rng = rng;
    }

    @Override
    public void setRNG(RandomNumberGenerator m) {
        this.rng = m;
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    @Override
    public void setProperties(Properties p) {
        this.maxDepth = Integer.parseInt(p.getProperty("max_depth", "-1"));
        if (this.maxDepth == -1) {
            throw new BadParameterException("max_depth", this.getClass().getName());
        }
        this.tailSize = Double.parseDouble(p.getProperty("tail_percentage", "-1.0"));
        if (this.tailSize < 0.0) {
            throw new BadParameterException("tail_percentage", this.getClass().getName());
        }
    }

    @Override
    public Individual createIndividual() {
        GEGrammar gram = GEGrammar.getGrammar(this.grammar);
        Phenotype phenotype = new Phenotype();
        int[] codons = new int[this.initChromSize];
        GEChromosome chrom = new GEChromosome(this.initChromSize, codons);
        if (gram.getMaxDerivationTreeDepth() < this.maxDepth) {
            gram.setMaxDerivationTreeDepth(this.maxDepth);
        }
        chrom.setMaxChromosomeLength(gram.getMaxChromosomeLengthByDepth());
        Genotype geno = new Genotype(1, chrom);
        BasicFitness fitness = new BasicFitness();
        GEIndividual gei = new GEIndividual(gram, phenotype, geno, fitness);
        return gei;
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public void setMinDepth(int minDepth) {
        this.minDepth = minDepth;
    }

    public void setMaxDepth(int i) {
        this.maxDepth = i;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public void doOperation(Individual operand) {
        GEIndividual ind = (GEIndividual)operand;
        ind.setGenotype(this.getGenotype(((GEChromosome)ind.getGenotype().get(0)).getMaxChromosomeLength()));
    }

    @Override
    public void doOperation(List<Individual> operands) {
    }

    public Genotype getGenotype(int maxLength) {
        this.genotype = new Genotype();
        this.chromosome = new GEChromosome(this.initChromSize);
        this.chromosome.setMaxChromosomeLength(maxLength);
        this.genotype.add(this.chromosome);
        NimbleTree<Symbol> dt = new NimbleTree<Symbol>(this.grammar.getStartSymbol());
        this.grow(dt);
        for (int extraCodons = (int)Math.ceil((double)this.chromosome.getLength() * this.tailSize); extraCodons > 0; --extraCodons) {
            this.chromosome.add(this.rng.nextInt(Integer.MAX_VALUE));
        }
        return this.genotype;
    }

    public boolean grow(NimbleTree<Symbol> dt) {
        try {
            if (dt.getDepth() > this.maxDepth) {
                return false;
            }
            if (dt.getCurrentNode().getData().getType() == Enums.SymbolType.TSymbol) {
                return true;
            }
            Rule rule = this.grammar.findRule(dt.getCurrentNode().getData());
            if (rule != null) {
                Production prod;
                int tmp;
                int diff;
                ArrayList<Integer> possibleRules = this.getPossibleRules(dt, rule);
                if (possibleRules.isEmpty()) {
                    return false;
                }
                int prodVal = this.rng.nextInt(possibleRules.size());
                int modVal = possibleRules.get(prodVal);
                int tmp1 = this.rng.nextInt(Integer.MAX_VALUE - rule.size());
                int mod = tmp1 % rule.size();
                if (mod > modVal) {
                    diff = mod - modVal;
                    tmp = tmp1 - diff;
                } else {
                    diff = modVal - mod;
                    tmp = tmp1 + diff;
                }
                int newMod = tmp % rule.size();
                if (newMod != modVal) {
                    throw new InitializationException("Error calculating mod value:\nmodVal:" + modVal + " tmp1:" + tmp1 + " mod:" + mod + " tmp:" + tmp + " rule.size():" + rule.size() + " newMod:" + newMod);
                }
                if (rule.size() > 1) {
                    this.chromosome.add(tmp);
                    prod = (Production)rule.get(possibleRules.get(prodVal));
                } else {
                    prod = (Production)rule.get(0);
                }
                boolean result = true;
                for (Symbol symbol : prod) {
                    dt.addChild(symbol);
                    TreeNode<Symbol> parent = dt.getCurrentNode();
                    dt.setCurrentNode(parent.getEnd());
                    result &= this.grow(dt);
                    dt.setCurrentNode(parent);
                }
                this.chromosome.setValid(result);
                return result;
            }
            if (!this.checkGECodonValue(dt)) {
                throw new InitializationException("Non-existent rule, maybe GECODON not yet impelemnted. Could not find" + dt.getCurrentNode().getData().getSymbolString());
            }
        }
        catch (InitializationException e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return false;
    }

    public ArrayList<Integer> getPossibleRules(NimbleTree<Symbol> dt, Rule rule) {
        ArrayList<Integer> possibleRules = new ArrayList<Integer>();
        int i = 0;
        for (Production p : rule) {
            if (dt.getCurrentNode().getDepth() + 1 + p.getMinimumDepth() <= this.maxDepth) {
                possibleRules.add(i);
            }
            ++i;
        }
        return possibleRules;
    }

    protected boolean checkGECodonValue(NimbleTree<Symbol> dt) {
        boolean ret = false;
        if (dt.getCurrentNode().getData().getSymbolString().contains(Constants.GE_CODON_VALUE)) {
            this.chromosome.add(this.rng.nextInt(Integer.MAX_VALUE));
            ret = true;
        }
        return ret;
    }
}

