/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import FitnessEvaluation.FitnessFunction;
import Individuals.Individual;
import Mapper.GEGrammar;
import Operator.Operations.Operation;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class FitnessEvaluationOperation
implements Operation {
    private FitnessFunction fitnessFunction;
    private boolean evaluateEverytime = false;
    private HashMap<String, CacheItem> fitnessCache = new HashMap();
    private int currentAge;
    private int originalPopulationSize;
    private int populationSize;
    private static final int GENERATIONS_SURVIVAL = 10;

    public FitnessEvaluationOperation(FitnessFunction ff) {
        this.fitnessFunction = ff;
        new CacheMemoryMonitor();
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    HashMap<String, CacheItem> getFitnessCache() {
        return this.fitnessCache;
    }

    @Override
    public void doOperation(Individual operand) {
        operand.setEvaluated(false);
        if (!operand.isEvaluated()) {
            if (operand.getGenotype() == null && operand.getPhenotype() != null) {
                if (operand.isValid()) {
                    this.fitnessFunction.getFitness(operand);
                } else {
                    operand.getFitness().setDefault();
                }
                return;
            }
            operand.map(0);
            boolean cache = this.fitnessFunction.canCache();
            if (!cache || !this.getFitnessFromCache(operand)) {
                if (operand.isValid()) {
                    this.fitnessFunction.getFitness(operand);
                } else {
                    operand.getFitness().setDefault();
                }
                if (cache) {
                    this.addFitnessToCache(operand);
                }
            }
            if (this.evaluateEverytime) {
                operand.setEvaluated(false);
            } else {
                operand.setEvaluated(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getFitnessFromCache(Individual operand) {
        assert (this.fitnessFunction.canCache());
        String fitnessName = ((GEGrammar)operand.getMapper()).getName();
        HashMap<String, CacheItem> hashMap = this.fitnessCache;
        synchronized (hashMap) {
            if (this.fitnessCache.containsKey(fitnessName)) {
                CacheItem cacheItem = this.fitnessCache.get(fitnessName);
                cacheItem.age = this.currentAge++;
                ++cacheItem.lives;
                operand.getFitness().setDouble(cacheItem.value);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFitnessToCache(Individual operand) {
        assert (this.fitnessFunction.canCache());
        HashMap<String, CacheItem> hashMap = this.fitnessCache;
        synchronized (hashMap) {
            this.fitnessCache.put(((GEGrammar)operand.getMapper()).getName(), new CacheItem(operand.getFitness().getDouble(), this.currentAge++));
            if (this.fitnessCache.size() >= this.populationSize * 10) {
                Set<Map.Entry<String, CacheItem>> entries = this.fitnessCache.entrySet();
                Iterator<Map.Entry<String, CacheItem>> entry = entries.iterator();
                while (entry.hasNext()) {
                    CacheItem item = entry.next().getValue();
                    if (item.age - this.currentAge >= -this.populationSize * 10 / 2) continue;
                    --item.lives;
                    if (item.lives > 0) continue;
                    entry.remove();
                }
                if (this.fitnessCache.size() > this.originalPopulationSize * 10 / 2) {
                    this.populationSize = this.fitnessCache.size() * 2 / 10;
                }
            }
        }
    }

    @Override
    public void setProperties(Properties p) {
        String value = p.getProperty("population_size");
        try {
            this.originalPopulationSize = this.populationSize = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            this.populationSize = Integer.parseInt("10");
        }
    }

    public int getOriginalPopulationSize() {
        return this.originalPopulationSize;
    }

    @Override
    public void doOperation(List<Individual> operands) {
        Iterator<Individual> i$ = operands.iterator();
        while (i$.hasNext()) {
            Individual operand;
            Individual ind = operand = i$.next();
            this.doOperation(ind);
        }
    }

    public FitnessFunction getFitnessFunction() {
        return this.fitnessFunction;
    }

    private class CacheMemoryMonitor {
        private static final float memoryThreshold = 0.75f;

        public CacheMemoryMonitor() {
            this.initialiseThreshold();
            this.initialiseMonitor();
        }

        private void initialiseThreshold() {
            for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
                pool.setUsageThreshold((long)((float)pool.getUsage().getMax() * 0.75f));
            }
        }

        private void initialiseMonitor() {
            MemoryMXBean memoryMonitor = ManagementFactory.getMemoryMXBean();
            ((NotificationEmitter)((Object)memoryMonitor)).addNotificationListener(new NotificationListener(){

                @Override
                public void handleNotification(Notification notification, Object userData) {
                    if (notification.getType().equals("java.management.memory.threshold.exceeded")) {
                        CacheMemoryMonitor.this.preformCleanup();
                    }
                }
            }, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void preformCleanup() {
            HashMap hashMap = FitnessEvaluationOperation.this.fitnessCache;
            synchronized (hashMap) {
                Set entries = FitnessEvaluationOperation.this.fitnessCache.entrySet();
                Iterator entry = entries.iterator();
                for (int size = FitnessEvaluationOperation.this.fitnessCache.size() / 2; entry.hasNext() && size > 0; --size) {
                    entry.next();
                    entry.remove();
                }
            }
        }
    }

    private class CacheItem {
        public double value;
        public int age;
        public int lives;

        public CacheItem(double value, int age) {
            this.value = value;
            this.age = age;
            this.lives = 1;
        }
    }
}

