/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Individuals.FitnessPackage.Fitness;
import Individuals.Individual;
import Operator.Operations.Operation;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class EliteReplacementOperation
implements Operation {
    private int eliteSize;

    public EliteReplacementOperation(int size) {
        this.eliteSize = size;
    }

    public EliteReplacementOperation(Properties p) {
        this.setProperties(p);
    }

    @Override
    public void setProperties(Properties p) {
        int value = 0;
        String key = "elite_size";
        value = Integer.parseInt(p.getProperty(key, "0"));
        if (value == -1) {
            value = 0;
        }
        this.eliteSize = value;
    }

    @Override
    public void doOperation(Individual operand) {
    }

    @Override
    public void doOperation(List<Individual> operand) {
        Collections.sort(operand);
        int cnt = operand.size();
        while (cnt > this.eliteSize && cnt > 0) {
            operand.remove(--cnt);
        }
    }

    public int getEliteSize() {
        return this.eliteSize;
    }

    public void printHelp(Fitness[] fA) {
        StringBuffer s = new StringBuffer();
        for (Fitness aFA : fA) {
            s.append(aFA.getDouble());
            s.append(",");
        }
        System.out.println("sorted elites:" + s);
    }
}

