/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Individuals.FitnessPackage.Fitness;
import Individuals.GEIndividual;
import Individuals.Individual;
import Individuals.Populations.SimplePopulation;
import Operator.Operations.SelectionOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class EliteOperationSelection
extends SelectionOperation {
    private boolean evaluate_elites;

    public EliteOperationSelection(int size) {
        super(size);
    }

    public EliteOperationSelection(Properties p) {
        this.setProperties(p);
    }

    @Override
    public void setProperties(Properties p) {
        String valueS;
        int value = 0;
        String key = "elite_size";
        value = Integer.parseInt(p.getProperty(key, "0"));
        if (value == -1) {
            value = 0;
        }
        this.size = value;
        key = "evaluate_elites";
        try {
            valueS = p.getProperty(key);
            if (valueS == null) {
                valueS = "false";
            }
        }
        catch (Exception e) {
            valueS = "false";
            System.out.println(this.getClass().getName() + ".setProperties " + e + " using default: " + valueS);
        }
        this.evaluate_elites = valueS.equals("true");
        this.selectedPopulation = new SimplePopulation(this.size);
    }

    public boolean isEvaluateElites() {
        return this.evaluate_elites;
    }

    @Override
    public void doOperation(Individual operand) {
    }

    @Override
    public void doOperation(List<Individual> operands) {
        Fitness[] fA = this.rankPopulation(operands);
        for (int cnt = 0; cnt < this.size && cnt < operands.size(); ++cnt) {
            boolean valid = fA[cnt].getIndividual().isValid();
            boolean duplicate = this.selectedPopulation.contains(fA[cnt].getIndividual());
            if (duplicate || !valid) continue;
            Individual ind = fA[cnt].getIndividual().clone();
            if (!this.evaluate_elites) {
                ind.setEvaluated(fA[cnt].getIndividual().isEvaluated());
                ind.setValid(fA[cnt].getIndividual().isValid());
                ind.setAge(fA[cnt].getIndividual().getAge());
                ((GEIndividual)ind).setMapped(((GEIndividual)fA[cnt].getIndividual()).isMapped());
                ((GEIndividual)ind).setUsedCodons(((GEIndividual)fA[cnt].getIndividual()).getUsedCodons());
            }
            this.selectedPopulation.add(ind);
        }
    }

    public void setEvaluate_elites(boolean evaluate_elites) {
        this.evaluate_elites = evaluate_elites;
    }

    Fitness[] rankPopulation(List<Individual> operands) {
        Object[] fAt = new Fitness[operands.size()];
        for (int i = 0; i < fAt.length; ++i) {
            fAt[i] = operands.get(i).getFitness();
        }
        Arrays.sort(fAt);
        return fAt;
    }
}

