/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations.ContextSensitiveOperations;

import Exceptions.BadParameterException;
import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Individual;
import Mapper.DerivationNode;
import Mapper.DerivationTree;
import Mapper.GEGrammar;
import Operator.Initialiser;
import Operator.Operations.CreationOperation;
import Operator.Operations.FullInitialiser;
import Operator.Operations.GrowInitialiser;
import Operator.Operations.MutationOperation;
import Operator.Operations.RandomInitialiser;
import Operator.RampedHalfAndHalfInitialiser;
import Util.GenotypeHelper;
import Util.Random.RandomNumberGenerator;
import Util.Structures.TreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class SubtreeMutation
extends MutationOperation {
    private CreationOperation creationOperation;
    protected Initialiser initialiser;

    public SubtreeMutation(RandomNumberGenerator rng, Properties p) {
        super(rng, p);
        GEGrammar geg = null;
        String key = "gegrammar";
        try {
            String className = p.getProperty(key, "Mapper.GEGrammar");
            Class<?> clazz = Class.forName(className);
            geg = (GEGrammar)clazz.newInstance();
            geg.setProperties(p);
        }
        catch (Exception e) {
            System.err.println(this.getClass().getName() + "Could not Create Grammar" + e);
        }
        this.initialiser = this.getInitialiser(geg, this.rng, p);
        this.creationOperation = (CreationOperation)this.initialiser.getOperation();
    }

    public SubtreeMutation(double prob, RandomNumberGenerator rng) {
        super(prob, rng);
    }

    public void setCreationOperation(CreationOperation creationOperation) {
        this.creationOperation = creationOperation;
    }

    @Override
    public void doOperation(Individual operand) {
        if (this.rng.nextDouble() >= this.probability) {
            return;
        }
        DerivationTree tree = GenotypeHelper.buildDerivationTree(operand);
        boolean isValid = false;
        if (tree == null) {
            return;
        }
        while (!isValid) {
            int point;
            isValid = true;
            GEChromosome chromosome = (GEChromosome)operand.getGenotype().get(0);
            int maxPoint = this.getMaxDTIndex(tree);
            if (maxPoint == 0) {
                point = 0;
            } else {
                point = this.rng.nextInt(maxPoint);
                assert (point >= 0 & point < maxPoint) : "Problem mutating tree:\n" + tree + "\nat point: " + point;
            }
            DerivationNode node = GenotypeHelper.findNodeFromCodonIndex(tree, point, chromosome.getUsedGenes());
            assert (node != null);
            Individual mutation = this.buildMutatedIndividual(node);
            if (mutation != null) {
                int length = GenotypeHelper.calcNodeLength(node);
                chromosome = GenotypeHelper.makeNewChromosome(operand, point, length, mutation, tree);
                Individual testOperand = operand.clone();
                ((GEChromosome)testOperand.getGenotype().get(0)).setAll(chromosome.data);
                DerivationTree validTree = GenotypeHelper.buildDerivationTree(testOperand);
                if (validTree == null) {
                    isValid = false;
                } else {
                    operand.getGenotype().set(0, chromosome);
                    operand.getMapper().setGenotype(chromosome);
                    ((GEIndividual)operand).invalidate();
                    operand.map(0);
                }
            } else {
                isValid = false;
            }
            if (isValid || !(this.rng.nextDouble() >= this.probability)) continue;
            return;
        }
    }

    public int getMaxDTIndex(DerivationTree dT) {
        TreeNode currItr = dT.getRoot();
        LinkedList visitNodes = new LinkedList();
        visitNodes.add(currItr);
        int maxIndex = 0;
        while (visitNodes.size() > 0) {
            currItr = (TreeNode)visitNodes.remove(0);
            DerivationNode DN = (DerivationNode)currItr;
            if (DN.getCodonIndex() > maxIndex) {
                maxIndex = DN.getCodonIndex();
            }
            Iterator nodeItr = currItr.iterator();
            while (nodeItr.hasNext()) {
                visitNodes.add(nodeItr.next());
            }
        }
        return maxIndex;
    }

    @Override
    public void doOperation(List<Individual> operands) {
        for (Individual operand : operands) {
            this.doOperation(operand);
        }
    }

    private Individual buildMutatedIndividual(DerivationNode node) {
        Individual individual = this.creationOperation.createIndividual();
        this.creationOperation.doOperation(individual);
        if (GenotypeHelper.buildDerivationTree(individual, node) != null) {
            return individual;
        }
        return null;
    }

    protected Initialiser getInitialiser(GEGrammar g, RandomNumberGenerator rng, Properties p) {
        String key = "initialiser";
        try {
            String className = p.getProperty(key);
            if (className == null) {
                throw new BadParameterException(key);
            }
            Class<?> clazz = Class.forName(className);
            this.initialiser = (Initialiser)clazz.newInstance();
            if (clazz.getName().equals(RampedHalfAndHalfInitialiser.class.getName())) {
                FullInitialiser fullInitialiser = new FullInitialiser(rng, g, p);
                GrowInitialiser growInitialiser = new GrowInitialiser(rng, g, p);
                ArrayList<CreationOperation> opL = new ArrayList<CreationOperation>();
                opL.add(fullInitialiser);
                opL.add(growInitialiser);
                ((RampedHalfAndHalfInitialiser)this.initialiser).setOperations(opL);
            } else {
                RandomInitialiser randomInitialiser = new RandomInitialiser(rng, g, p);
                this.initialiser.setOperation(randomInitialiser);
            }
            this.initialiser.setProperties(p);
            this.initialiser.setRNG(rng);
            this.initialiser.init();
        }
        catch (Exception e) {
            System.out.println(this.getClass().getName() + ".getInitialiser(.) Exception: " + e);
            e.printStackTrace();
        }
        return this.initialiser;
    }
}

