/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations.ContextSensitiveOperations;

import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Individual;
import Mapper.DerivationNode;
import Mapper.DerivationTree;
import Mapper.Symbol;
import Operator.Operations.CrossoverOperation;
import Util.GenotypeHelper;
import Util.Random.RandomNumberGenerator;
import java.util.List;
import java.util.Properties;

public class SubtreeCrossover
extends CrossoverOperation {
    public SubtreeCrossover(RandomNumberGenerator rng, Properties p) {
        super(rng, p);
    }

    public SubtreeCrossover(double prob, RandomNumberGenerator rng) {
        super(prob, rng);
    }

    @Override
    public void doOperation(List<Individual> operands) {
        assert (operands.size() >= 2) : operands.size();
        Individual i1 = operands.get(0);
        Individual i2 = operands.get(1);
        if (this.rand.nextDouble() >= this.probability) {
            return;
        }
        DerivationTree tree1 = GenotypeHelper.buildDerivationTree(i1);
        DerivationTree tree2 = GenotypeHelper.buildDerivationTree(i2);
        if (tree1 == null || tree2 == null) {
            return;
        }
        GEChromosome chromosome1 = (GEChromosome)i1.getGenotype().get(0);
        GEChromosome chromosome2 = (GEChromosome)i2.getGenotype().get(0);
        boolean[] wasPicked = new boolean[chromosome1.getUsedGenes()];
        int pickCount = wasPicked.length;
        DerivationNode node1 = null;
        DerivationNode node2 = null;
        int point1 = 0;
        int point2 = 0;
        int length1 = 0;
        int length2 = 0;
        while (node2 == null) {
            assert (pickCount > 0 && pickCount <= chromosome1.getUsedGenes()) : pickCount;
            int maxPoint1 = GenotypeHelper.getMaxDTIndex(tree1);
            point1 = maxPoint1 == 0 ? 0 : (maxPoint1 < pickCount ? super.getRNG().nextInt(maxPoint1) : super.getRNG().nextInt(pickCount));
            int maxPoint2 = GenotypeHelper.getMaxDTIndex(tree2);
            point2 = maxPoint2 == 0 ? 0 : super.getRNG().nextInt(maxPoint2);
            assert (point1 >= 0 && point1 < pickCount) : point1;
            assert (point2 >= 0 && point2 < chromosome2.getUsedGenes()) : point2;
            for (int pickIndex = 0; pickIndex < wasPicked.length; ++pickIndex) {
                if (wasPicked[pickIndex]) continue;
                if (point1 == 0) {
                    wasPicked[pickIndex] = true;
                    point1 = pickIndex;
                    pickIndex = wasPicked.length;
                    continue;
                }
                --point1;
            }
            --pickCount;
            assert (point1 >= 0 && point1 < chromosome1.getUsedGenes()) : point1;
            assert (pickCount >= 0) : pickCount;
            node1 = GenotypeHelper.findNodeFromCodonIndex(tree1, point1);
            assert (node1 != null);
            node2 = this.findRelatedNode(tree2, point2, maxPoint2, node1);
            if (node2 == null) continue;
            point2 = node2.getCodonIndex();
            length1 = GenotypeHelper.calcNodeLength(node1);
            length2 = GenotypeHelper.calcNodeLength(node2);
        }
        assert (point1 + length1 <= chromosome1.getUsedGenes()) : point1 + "+" + length1 + ":" + chromosome1.getUsedGenes();
        assert (point2 + length2 <= chromosome2.getUsedGenes()) : point2 + "+" + length2 + ":" + chromosome2.getUsedGenes();
        chromosome1 = GenotypeHelper.makeNewChromosome(i1, point1, length1, i2, point2, length2);
        chromosome2 = GenotypeHelper.makeNewChromosome(i2, point2, length2, i1, point1, length1);
        i1.getGenotype().set(0, chromosome1);
        i2.getGenotype().set(0, chromosome2);
        i1.getMapper().setGenotype(chromosome1);
        i2.getMapper().setGenotype(chromosome2);
        ((GEIndividual)i1).invalidate();
        ((GEIndividual)i2).invalidate();
        i1.map(0);
        i2.map(0);
    }

    @Override
    public void doOperation(Individual operand) {
    }

    private DerivationNode findRelatedNode(DerivationTree tree, int codonIndex, int codonTotal, DerivationNode relatedNode) {
        int offset = 0;
        boolean Continue = true;
        while (Continue) {
            DerivationNode node;
            Continue = false;
            if (codonIndex + offset < codonTotal) {
                node = GenotypeHelper.findNodeFromCodonIndex(tree, codonIndex + offset);
                if (((Symbol)node.getData()).equals((Symbol)relatedNode.getData())) {
                    return node;
                }
                Continue = true;
            }
            if (offset != 0 && codonIndex - offset >= 0) {
                node = GenotypeHelper.findNodeFromCodonIndex(tree, codonIndex - offset);
                if (((Symbol)node.getData()).equals((Symbol)relatedNode.getData())) {
                    return node;
                }
                Continue = true;
            }
            if (codonIndex + offset == 0 && codonTotal == 0) {
                node = GenotypeHelper.findNodeFromCodonIndex(tree, 0);
                if (((Symbol)node.getData()).equals((Symbol)relatedNode.getData())) {
                    return node;
                }
                Continue = true;
            }
            ++offset;
        }
        return null;
    }
}

