/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations.ContextSensitiveOperations;

import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Individual;
import Mapper.ContextualDerivationTree;
import Operator.Operations.MutationOperation;
import Util.GenotypeHelper;
import Util.Random.RandomNumberGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class StructuralMutation
extends MutationOperation {
    public StructuralMutation(RandomNumberGenerator rng, Properties p) {
        super(rng, p);
    }

    public StructuralMutation(double prob, RandomNumberGenerator rng) {
        super(prob, rng);
    }

    @Override
    public void doOperation(Individual operand) {
        ContextualDerivationTree tree = (ContextualDerivationTree)GenotypeHelper.buildDerivationTree(operand);
        GEChromosome chromosome = (GEChromosome)operand.getGenotype().get(0);
        if (tree != null) {
            ArrayList<Integer> structCodonList = new ArrayList<Integer>(tree.getStructCodonList());
            for (int i = 0; i < structCodonList.size(); ++i) {
                int codonIndex = structCodonList.get(i);
                if (!this.rng.nextBoolean(this.probability)) continue;
                chromosome.set(codonIndex, Math.abs(this.rng.nextInt()));
                tree = (ContextualDerivationTree)GenotypeHelper.buildDerivationTree(operand);
            }
            ((GEIndividual)operand).invalidate();
            tree = null;
        }
    }

    @Override
    public void doOperation(List<Individual> operands) {
        for (Individual operand : operands) {
            this.doOperation(operand);
        }
    }
}

