/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations.ContextSensitiveOperations;

import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Individual;
import Mapper.ContextualDerivationTree;
import Operator.Operations.MutationOperation;
import Util.GenotypeHelper;
import Util.Random.RandomNumberGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class NodalMutation
extends MutationOperation {
    public NodalMutation(RandomNumberGenerator rng, Properties p) {
        super(rng, p);
    }

    public NodalMutation(double prob, RandomNumberGenerator rng) {
        super(prob, rng);
    }

    @Override
    public void doOperation(Individual operand) {
        ContextualDerivationTree tree = (ContextualDerivationTree)GenotypeHelper.buildDerivationTree(operand);
        GEChromosome chromosome = (GEChromosome)operand.getGenotype().get(0);
        if (tree != null) {
            ArrayList<Integer> nodeCodonList = new ArrayList<Integer>(tree.getNodeCodonList());
            for (int i = 0; i < nodeCodonList.size(); ++i) {
                int codonIndex = nodeCodonList.get(i);
                if (!this.rng.nextBoolean(this.probability)) continue;
                chromosome.set(codonIndex, Math.abs(this.rng.nextInt()));
            }
            ((GEIndividual)operand).invalidate();
            tree = null;
        }
    }

    @Override
    public void doOperation(List<Individual> operands) {
        for (Individual operand : operands) {
            this.doOperation(operand);
        }
    }
}

