/*
 * Decompiled with CFR 0.152.
 */
package Mapper;

import Mapper.Production;
import Mapper.Symbol;
import Util.Enums;
import java.util.ArrayList;

public class Rule
extends ArrayList<Production> {
    private boolean recursive;
    private int minimumDepth;
    private Symbol lhs;

    public Rule(int newLength) {
        super(newLength);
        this.setRecursive(false);
        this.setMinimumDepth(0x3FFFFFFF);
    }

    public Rule() {
    }

    public Rule(Rule copy) {
        super(copy);
        this.lhs = copy.lhs;
        this.recursive = copy.recursive;
        this.minimumDepth = copy.minimumDepth;
    }

    public boolean getRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean newRecursive) {
        this.recursive = newRecursive;
    }

    public int getMinimumDepth() {
        return this.minimumDepth;
    }

    public void setMinimumDepth(int newMinimumDepth) {
        this.minimumDepth = newMinimumDepth;
    }

    public void setLHS(Symbol s) {
        assert (s.getType() == Enums.SymbolType.NTSymbol) : "Bad type: " + (Object)((Object)s.getType());
        if (s.getType() == Enums.SymbolType.NTSymbol) {
            this.lhs = s;
        }
    }

    public Symbol getLHS() {
        return this.lhs;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.lhs.getSymbolString());
        s.append("::=");
        for (int i = 0; i < this.size(); ++i) {
            s.append(this.get(i));
            if (i >= this.size() - 1) continue;
            s.append("|");
        }
        return s.toString();
    }
}

