/*
 * Decompiled with CFR 0.152.
 */
package Mapper;

import Mapper.Symbol;
import Util.Constants;
import Util.Enums;
import java.util.ArrayList;

public class Production
extends ArrayList<Symbol> {
    private boolean recursive;
    private int minimumDepth;

    public Production(int newLength) {
        super(newLength);
        this.setRecursive(false);
        this.setMinimumDepth(0x3FFFFFFF);
    }

    public Production() {
    }

    public Production(Production copy) {
        super(copy);
        this.recursive = copy.recursive;
        this.minimumDepth = copy.minimumDepth;
    }

    public boolean getRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean newRecursive) {
        this.recursive = newRecursive;
    }

    public int getMinimumDepth() {
        return this.minimumDepth;
    }

    public void setMinimumDepth(int newMinimumDepth) {
        this.minimumDepth = newMinimumDepth;
    }

    public int getNTSymbols() {
        int cnt = 0;
        for (Symbol o : this) {
            if (o.getType() != Enums.SymbolType.NTSymbol || o.getSymbolString().startsWith(Constants.GE_CODON_VALUE_PARSING)) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            s.append(((Symbol)this.get(i)).getSymbolString());
        }
        return s.toString();
    }
}

