/*
 * Decompiled with CFR 0.152.
 */
package Mapper;

import Exceptions.BadParameterException;
import Individuals.GEChromosome;
import Individuals.Phenotype;
import Mapper.ContextFreeGrammar;
import Mapper.DerivationNode;
import Mapper.DerivationTree;
import Mapper.Production;
import Mapper.Rule;
import Mapper.Symbol;
import Mapper.TreeMill;
import Parameter.ParameterI;
import Util.Constants;
import Util.Enums;
import Util.Random.MersenneTwisterFast;
import java.io.File;
import java.util.Properties;
import java.util.Stack;

public class GEGrammar
extends ContextFreeGrammar
implements ParameterI {
    private int PRCSetSize;
    private int PRCRange;
    private int PRCPrecision;
    GEChromosome genotype;
    Phenotype phenotype;
    int maxWraps;
    int usedWraps;
    int usedCodons;
    String name;
    DerivationTree dT;
    int maxDerivationTreeDepth;
    int maxCurrentTreeDepth;
    int dTNodeCount;
    private String derivationTreeType;

    public GEGrammar() {
        this.maxWraps = 1;
    }

    public GEGrammar(String file) {
        this.readBNFFile(file);
        this.maxWraps = 1;
    }

    public GEGrammar(Properties p) {
        this.setProperties(p);
    }

    public GEGrammar(GEGrammar copy) {
        super(copy);
        this.derivationTreeType = copy.getDerivationString();
        this.setMaxWraps(copy.getMaxWraps());
        this.maxWraps = copy.maxWraps;
        this.maxDerivationTreeDepth = copy.getMaxDerivationTreeDepth();
        this.maxCurrentTreeDepth = copy.getMaxCurrentTreeDepth();
        if (this.dT != null) {
            this.dT = new DerivationTree(copy.dT);
        }
        this.dTNodeCount = copy.getDTNodeCount();
        this.name = copy.name;
        this.maxDerivationTreeDepth = copy.getMaxDerivationTreeDepth();
        this.maxCurrentTreeDepth = copy.getMaxCurrentTreeDepth();
    }

    @Override
    public void setProperties(Properties p) {
        int value;
        String key;
        String file = null;
        try {
            key = "grammar_file";
            file = p.getProperty(key);
            if (file == null) {
                throw new BadParameterException(key);
            }
        }
        catch (BadParameterException e) {
            System.out.println(e + " No default grammar");
        }
        File f = new File(file);
        if (!f.exists()) {
            this.readBNFFile(file);
        } else {
            this.readBNFFileFromFilesystem(file);
        }
        try {
            key = "max_wraps";
            value = Integer.parseInt(p.getProperty(key));
            if (value < 0) {
                throw new BadParameterException(key);
            }
        }
        catch (BadParameterException e) {
            value = 0;
            System.out.println(e + " default wraps:" + value);
        }
        this.maxWraps = value + 1;
        try {
            this.PRCSetSize = Integer.parseInt(p.getProperty("prc_setsize", "0"));
            this.PRCRange = Integer.parseInt(p.getProperty("prc_range", "100"));
            this.PRCPrecision = Integer.parseInt(p.getProperty("prc_precision", "0"));
            if (this.PRCSetSize < 0) {
                throw new BadParameterException("prc_setsize");
            }
            if (this.PRCRange < 0) {
                throw new BadParameterException("prc_range");
            }
            if (this.PRCPrecision < 0 || this.PRCPrecision > 32) {
                throw new BadParameterException("prc_precision");
            }
        }
        catch (BadParameterException e) {
            value = 0;
            System.out.println(e + " constant range:" + value);
        }
        if (this.PRCSetSize > 0) {
            this.generatePRC();
        }
        this.maxWraps = value + 1;
        this.maxDerivationTreeDepth = Integer.parseInt(p.getProperty("max_dt_depth", Constants.DEFAULT_MAX_DERIVATION_TREE_DEPTH));
        this.derivationTreeType = p.getProperty(Constants.DERIVATION_TREE);
        if (this.maxWraps > 1 && this.derivationTreeType.equals("Mapper.ContextualDerivationTree")) {
            throw new IllegalArgumentException("Wrapping must be turned off for Context Sensitive trees");
        }
    }

    @Override
    public boolean genotype2Phenotype() {
        return this.genotype2Phenotype(false);
    }

    @Override
    public boolean phenotype2Genotype() {
        return true;
    }

    public void generatePRC() {
        Rule oldRule = this.findRule("<prc>");
        if (oldRule != null) {
            System.out.println("<prc> rule found in grammar, generating constants");
            MersenneTwisterFast m = new MersenneTwisterFast();
            Rule newRule = new Rule(this.PRCSetSize);
            newRule.setLHS(oldRule.getLHS());
            Symbol newSymbol = new Symbol();
            newSymbol.setType(Enums.SymbolType.TSymbol);
            for (int i = 0; i < this.PRCSetSize; ++i) {
                int divisor = (int)Math.pow(10.0, this.PRCPrecision);
                float constant = Math.abs((float)m.nextInt());
                constant %= (float)(this.PRCRange * divisor);
                StringBuffer strConst = new StringBuffer();
                strConst.append(constant /= (float)divisor);
                newSymbol.setSymbolString(strConst.toString());
                Production np = new Production();
                np.add(new Symbol(newSymbol));
                newRule.add(np);
            }
            int x = this.rules.indexOf(oldRule);
            this.rules.remove(x);
            this.rules.add(x, newRule);
            System.out.println("PRC SetSize: " + this.PRCSetSize + " PRC Range: " + this.PRCRange + " PRC Precision: " + this.PRCPrecision);
            System.out.println("elements in the rule:" + newRule.toString());
        } else {
            System.out.println("Warning, PRC attributes specified but no <prc> rule in the grammar, no constants generated");
        }
    }

    @Override
    public void clear() {
        this.setValidGrammar(false);
        this.rules.clear();
        this.setStartSymbol(0);
        this.rules.clear();
    }

    public boolean genotype2Phenotype(boolean b) {
        boolean validMap;
        if (b) {
            this.phenotype.clear();
            this.dT = TreeMill.getDerivationTree(this);
            validMap = this.dT.derive();
            this.setDerivationTree(this.dT);
            this.usedCodons = this.dT.getGeneCnt();
            this.usedWraps = this.dT.getWrapCount();
            this.maxCurrentTreeDepth = this.dT.getDepth();
            this.name = this.generateNameFromTree(this.dT);
            this.dT = null;
        } else {
            validMap = true;
        }
        return validMap;
    }

    String generateNameFromTree(DerivationTree tree) {
        StringBuilder builder = new StringBuilder();
        Stack<DerivationNode> nodeStack = new Stack<DerivationNode>();
        nodeStack.push((DerivationNode)tree.getRoot());
        while (!nodeStack.empty()) {
            DerivationNode nodes = (DerivationNode)nodeStack.pop();
            if (nodes != null) {
                if (nodes.getCodonIndex() != -1) {
                    builder.append(nodes.getCodonPick());
                }
                if (nodes.size() == 0) continue;
                builder.append('[');
                nodeStack.push(null);
                for (int i = nodes.size(); i > 0; --i) {
                    nodeStack.push((DerivationNode)nodes.get(i - 1));
                }
                continue;
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static GEGrammar getGrammar(GEGrammar g) {
        GEGrammar grammar = new GEGrammar(g);
        return grammar;
    }

    public int getMaxCurrentTreeDepth() {
        return this.maxCurrentTreeDepth;
    }

    public void setMaxCurrentTreeDepth(int maxCurrentTreeDepth) {
        this.maxCurrentTreeDepth = maxCurrentTreeDepth;
    }

    public int getMaxWraps() {
        return this.maxWraps;
    }

    public void setMaxWraps(int i) {
        this.maxWraps = i;
    }

    public void setGenotype(GEChromosome genotype) {
        this.genotype = genotype;
    }

    public void setPhenotype(Phenotype phenotype) {
        this.phenotype = phenotype;
    }

    @Override
    public Phenotype getPhenotype() {
        return this.phenotype;
    }

    @Override
    public GEChromosome getGenotype() {
        return this.genotype;
    }

    @Override
    public void setPhenotype(Object p) {
        this.phenotype = (Phenotype)p;
    }

    @Override
    public void setGenotype(Object g) {
        this.genotype = (GEChromosome)g;
    }

    @Override
    public int getUsedCodons() {
        return this.usedCodons;
    }

    @Override
    public int getUsedWraps() {
        return this.usedWraps;
    }

    public int getMaxDerivationTreeDepth() {
        return this.maxDerivationTreeDepth;
    }

    public void setMaxDerivationTreeDepth(int maxDerivationTreeDepth) {
        this.maxDerivationTreeDepth = maxDerivationTreeDepth;
    }

    public void setDerivationTree(DerivationTree dT) {
        this.dT = dT;
    }

    public DerivationTree getDerivationTree() {
        return this.dT;
    }

    public int getMaxChromosomeLengthByDepth() {
        int len = Integer.MAX_VALUE;
        if (this.maxDerivationTreeDepth < Integer.MAX_VALUE) {
            int maxNTProd = 0;
            for (Rule r : this.rules) {
                for (Production p : r) {
                    if (maxNTProd >= p.getNTSymbols()) continue;
                    maxNTProd = p.getNTSymbols();
                }
            }
            len = 0;
            for (int i = 0; i < this.maxDerivationTreeDepth; ++i) {
                len = (int)((double)len + Math.pow(maxNTProd, i));
            }
        }
        return len;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GEGrammar that = (GEGrammar)obj;
        return this.name == that.name || this.name != null && this.name.equals(that.name);
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return 0;
    }

    public int getDTNodeCount() {
        return this.dTNodeCount;
    }

    public void setDerivationTreeType(String derivationTreeType) {
        this.derivationTreeType = derivationTreeType;
    }

    @Override
    public String getDerivationString() {
        return this.derivationTreeType;
    }
}

