/*
 * Decompiled with CFR 0.152.
 */
package Mapper;

import Exceptions.MalformedGrammarException;
import Individuals.GEChromosome;
import Mapper.Derivation;
import Mapper.DerivationNode;
import Mapper.GEGrammar;
import Mapper.Production;
import Mapper.Rule;
import Mapper.Symbol;
import Util.Constants;
import Util.Enums;
import Util.Structures.IntIterator;
import Util.Structures.NimbleTree;
import Util.Structures.TreeNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DerivationTree
extends NimbleTree<Symbol>
implements Derivation {
    protected final GEGrammar grammy;
    protected final GEChromosome genny;
    protected int wrapCount = 0;
    protected IntIterator genIter;
    protected int geneCnt;
    protected int currentCodonValue = -1;

    @Override
    protected TreeNode<Symbol> newNode() {
        return new DerivationNode();
    }

    public DerivationTree(GEGrammar gram, GEChromosome gen) {
        this.getRoot().setData(gram.getStartSymbol());
        this.genny = gen;
        this.grammy = gram;
        this.genIter = this.genny.iterator();
        this.wrapCount = 1;
        this.geneCnt = 0;
    }

    public DerivationTree(DerivationTree copy) {
        super(copy);
        this.grammy = new GEGrammar(copy.grammy);
        this.genny = new GEChromosome(copy.genny);
        this.wrapCount = copy.wrapCount;
        this.geneCnt = copy.geneCnt;
    }

    public boolean buildDerivationTree() {
        assert (this.getCurrentNode() instanceof DerivationNode) : this.getCurrentNode().getClass().getName();
        DerivationNode t = (DerivationNode)this.getCurrentNode();
        this.grammy.findRule((Symbol)t.getData());
        Boolean validBuild = this.growNode(t);
        this.genny.setUsedGenes(this.geneCnt);
        return validBuild;
    }

    protected String getGECodonValue(String s, int codon) throws MalformedGrammarException {
        String c = Constants.GE_CODON_VALUE_PARSING;
        if (s.indexOf("{") != -1) {
            if (s.indexOf("}") == -1) {
                throw new MalformedGrammarException("Bad GECodonValue specification: " + s);
            }
            String GECodonValueRE = c + "\\{(.*)\\}" + ">";
            Pattern pattern = Pattern.compile(GECodonValueRE);
            Matcher matcher = pattern.matcher(s);
            if (matcher.find()) {
                if (matcher.groupCount() == 1) {
                    String content = matcher.group(1);
                    String[] setValues = content.split(",");
                    return setValues[codon % setValues.length].trim();
                }
                throw new MalformedGrammarException("Bad GECodonValue specification (found too many matches): " + s);
            }
            throw new MalformedGrammarException("Bad GECodonValue specification (didn't find a match): " + s);
        }
        if (s.indexOf("(") != -1 || s.indexOf("[") != -1) {
            double highd;
            double lowd;
            int high;
            int low;
            boolean intMode;
            String[] boundaryValues;
            if (s.indexOf(")") == -1 && s.indexOf("]") == -1) {
                throw new MalformedGrammarException("Bad GECodonValue specification (didn't find closing brackets): " + s);
            }
            String GECodonValueRE = c + "([\\(\\[])(.*)([\\)\\]])" + ">";
            Pattern pattern = Pattern.compile(GECodonValueRE);
            Matcher matcher = pattern.matcher(s);
            if (matcher.find()) {
                if (matcher.groupCount() != 3) {
                    throw new MalformedGrammarException("Bad GECodonValue specification (didn't find opening and closing brackets and boundaries): " + s);
                }
                String content = matcher.group(2);
                boundaryValues = content.split(",");
                if (boundaryValues.length != 2) {
                    throw new MalformedGrammarException("Bad GECodonValue specification (didn't find upper and lower boundaries): " + s);
                }
            } else {
                throw new MalformedGrammarException("Bad GECodonValue specification (didn't find a match): " + s);
            }
            try {
                intMode = true;
                low = Integer.parseInt(boundaryValues[0].trim());
                high = Integer.parseInt(boundaryValues[1].trim());
                lowd = 0.0;
                highd = 0.0;
            }
            catch (Exception e) {
                intMode = false;
                lowd = Double.parseDouble(boundaryValues[0].trim());
                highd = Double.parseDouble(boundaryValues[1].trim());
                low = 0;
                high = this.genny.getMaxCodonValue();
            }
            if (matcher.group(1).equals("(")) {
                ++low;
                lowd += 1.0E-4;
            }
            if (matcher.group(3).equals(")")) {
                --high;
                highd -= 1.0E-4;
            }
            if (intMode) {
                if (low > high) {
                    throw new MalformedGrammarException("Bad GECodonValue specification (bad boundaries): " + s);
                }
                return String.valueOf(low + codon % (high - low + 1));
            }
            if (lowd > highd) {
                throw new MalformedGrammarException("Bad GECodonValue specification (bad boundaries): " + s);
            }
            return String.valueOf(lowd + (highd - lowd) * (double)codon / Double.valueOf(this.genny.getMaxCodonValue() - 0));
        }
        System.out.println("Warning: DerivationTree attempting to use GECodonValue legacy format");
        return this.getGECodonValueLegacyFormat(s, codon);
    }

    String getGECodonValueLegacyFormat(String s, int codon) {
        String codon_value;
        int low = 0;
        int high = -1;
        int i = Constants.GE_CODON_VALUE_PARSING.length();
        char currentChar = s.charAt(i);
        while (currentChar != '>') {
            if (currentChar == '-') {
                currentChar = s.charAt(i++);
                while (currentChar >= '0' && currentChar <= '9') {
                    low = low * 10 + (currentChar - 48);
                    currentChar = s.charAt(i++);
                }
                continue;
            }
            if (currentChar == '+') {
                currentChar = s.charAt(i++);
                while (currentChar >= '0' && currentChar <= '9') {
                    if (high == -1) {
                        high = 0;
                    }
                    high = high * 10 + (currentChar - 48);
                    currentChar = s.charAt(i++);
                }
                continue;
            }
            currentChar = s.charAt(i++);
        }
        if (high == -1) {
            high = this.genny.getMaxCodonValue();
        }
        if (high == low) {
            codon_value = String.valueOf(low);
        } else {
            codon = codon % (high - low + 1) + low;
            codon_value = String.valueOf(codon);
        }
        return codon_value;
    }

    protected boolean growNode(DerivationNode t) {
        Symbol s = (Symbol)t.getData();
        if (this.getDepth() > this.grammy.getMaxDerivationTreeDepth()) {
            return false;
        }
        if (this.geneCnt > this.genny.getMaxChromosomeLength()) {
            System.out.println("maxGEChromosomeLength exceeded:" + this.geneCnt + ">" + this.genny.getMaxChromosomeLength());
            return false;
        }
        if (s.getType() == Enums.SymbolType.NTSymbol) {
            Rule r = this.grammy.findRule(s);
            int numProd = r.size();
            if (!this.genIter.hasNext()) {
                ++this.wrapCount;
                this.genIter = this.genny.iterator();
            }
            if (this.wrapCount <= this.grammy.getMaxWraps() || numProd == 1 && !((Symbol)((Production)r.get(0)).get(0)).getSymbolString().startsWith(Constants.GE_CODON_VALUE_PARSING)) {
                Production p;
                if (numProd > 1) {
                    this.currentCodonValue = this.genIter.next();
                    t.setCodonIndex(this.geneCnt, this.currentCodonValue, this.currentCodonValue % numProd);
                    ++this.geneCnt;
                    p = (Production)r.get(this.currentCodonValue % numProd);
                } else {
                    if (((Symbol)((Production)r.get(0)).get(0)).getType() == Enums.SymbolType.NTSymbol && ((Symbol)((Production)r.get(0)).get(0)).getSymbolString().startsWith(Constants.GE_CODON_VALUE_PARSING)) {
                        t.setCodonIndex(this.geneCnt, this.currentCodonValue, 0);
                    }
                    p = (Production)r.get(0);
                }
                for (Symbol newSym : p) {
                    if (newSym.getType() == Enums.SymbolType.NTSymbol && newSym.getSymbolString().startsWith(Constants.GE_CODON_VALUE_PARSING)) {
                        String value;
                        if (!this.genIter.hasNext()) {
                            this.genIter = this.genny.iterator();
                            ++this.wrapCount;
                            if (this.wrapCount >= this.grammy.getMaxWraps()) {
                                return false;
                            }
                        }
                        ++this.geneCnt;
                        this.currentCodonValue = this.genIter.next();
                        try {
                            value = this.getGECodonValue(newSym.getSymbolString(), this.currentCodonValue);
                            t.setCodonIndex(this.geneCnt - 1, this.currentCodonValue, 0);
                        }
                        catch (MalformedGrammarException e) {
                            System.out.println("Malformed GECodonValue specification in grammar");
                            return false;
                        }
                        newSym = new Symbol(value, Enums.SymbolType.TSymbol);
                    }
                    DerivationNode newTree = new DerivationNode(t, newSym);
                    t.add(newTree);
                    this.setCurrentLevel(this.getCurrentLevel() + 1);
                    if (this.getDepth() < this.getCurrentLevel()) {
                        this.setDepth(this.getCurrentLevel());
                    }
                    newTree.setDepth(this.getCurrentLevel());
                    if (!this.growNode(newTree)) {
                        return false;
                    }
                    this.setCurrentLevel(this.getCurrentLevel() - 1);
                }
                return true;
            }
            return false;
        }
        this.grammy.getPhenotype().add(s);
        return true;
    }

    public int getWrapCount() {
        return this.wrapCount;
    }

    public void setWrapCount(int wrapCount) {
        this.wrapCount = wrapCount;
    }

    public int getGeneCnt() {
        return this.geneCnt;
    }

    @Override
    public boolean derive() {
        return this.buildDerivationTree();
    }
}

