/*
 * Decompiled with CFR 0.152.
 */
package Mapper;

import Individuals.GEChromosome;
import Mapper.DerivationNode;
import Mapper.DerivationTree;
import Mapper.GEGrammar;
import Mapper.Production;
import Mapper.Rule;
import Mapper.Symbol;
import Util.Constants;
import java.util.ArrayList;

public class ContextualDerivationTree
extends DerivationTree {
    private ArrayList<Integer> structCodonList;
    private ArrayList<Integer> nodeCodonList;
    private ArrayList<Symbol> terminalRules;
    private ArrayList<Symbol> nonTerminalRules;

    public ContextualDerivationTree(GEGrammar gram, GEChromosome gen) {
        super(gram, gen);
        this.terminalRules = gram.getTerminalRules();
        this.nonTerminalRules = gram.getNonTerminalRules();
        this.structCodonList = new ArrayList();
        this.nodeCodonList = new ArrayList();
    }

    public ContextualDerivationTree(ContextualDerivationTree copy) {
        super(copy);
        this.terminalRules = new ArrayList<Symbol>(copy.terminalRules);
        this.nonTerminalRules = new ArrayList<Symbol>(copy.nonTerminalRules);
        this.structCodonList = new ArrayList<Integer>(copy.structCodonList);
        this.nodeCodonList = new ArrayList<Integer>(copy.nodeCodonList);
    }

    @Override
    protected boolean growNode(DerivationNode t) {
        Symbol s = (Symbol)t.getData();
        boolean found = false;
        for (Symbol NTSymbol : this.nonTerminalRules) {
            if (!s.equals(NTSymbol)) continue;
            this.structCodonList.add(this.geneCnt);
            found = true;
        }
        Rule r = this.grammy.findRule(s);
        boolean usedCodon = false;
        if (r != null && !found && (r.size() > 1 || ((Symbol)((Production)r.get(0)).get(0)).getSymbolString().startsWith(Constants.GE_CODON_VALUE_PARSING))) {
            usedCodon = true;
        }
        if (usedCodon) {
            for (Symbol TSymbol : this.terminalRules) {
                if (!s.equals(TSymbol)) continue;
                this.nodeCodonList.add(this.geneCnt);
            }
        }
        boolean result = super.growNode(t);
        return result;
    }

    public ArrayList<Integer> getStructCodonList() {
        return this.structCodonList;
    }

    public ArrayList<Integer> getNodeCodonList() {
        return this.nodeCodonList;
    }
}

