/*
 * Decompiled with CFR 0.152.
 */
package Mapper;

import Exceptions.MalformedGrammarException;
import Mapper.Grammar;
import Mapper.Production;
import Mapper.Rule;
import Mapper.Symbol;
import Util.Constants;
import Util.Enums;
import Util.Structures.Queue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class ContextFreeGrammar
extends Grammar {
    @Override
    public abstract boolean genotype2Phenotype();

    @Override
    public abstract boolean phenotype2Genotype();

    public abstract int getUsedCodons();

    public abstract int getUsedWraps();

    ContextFreeGrammar() {
    }

    ContextFreeGrammar(ContextFreeGrammar g) {
        super(g);
    }

    public boolean readBNFFile(String file_name) {
        StringBuffer contents = new StringBuffer();
        try {
            String line;
            int bufferSize = 1024;
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            InputStream is = loader.getResourceAsStream(file_name);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr, bufferSize);
            assert (br != null) : "Cannot load resource from classloader: " + file_name;
            while ((line = br.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            System.err.println(this.getClass().getName() + " Grammar File not found: " + file_name);
            return false;
        }
        catch (NullPointerException e) {
            System.err.println(this.getClass().getName() + " Grammar File not found in classloader: " + file_name);
            return false;
        }
        catch (IOException e) {
            System.err.println(this.getClass().getName() + " IOException when looking for grammar file: " + file_name);
            return false;
        }
        contents.append("\n");
        return this.readBNFString(contents.toString());
    }

    boolean readBNFFileFromFilesystem(String file_name) {
        StringBuffer contents = new StringBuffer();
        try {
            String line;
            int bufferSize = 1024;
            File f = new File(file_name);
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr, 1024);
            while ((line = br.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            System.err.println(this.getClass().getName() + " Grammar File not found: " + file_name);
            return false;
        }
        catch (IOException e) {
            System.err.println(this.getClass().getName() + " IOException when opening grammar file: " + file_name);
            return false;
        }
        contents.append("\n");
        return this.readBNFString(contents.toString());
    }

    boolean readBNFString(String bnfString) {
        if (bnfString == null) {
            return false;
        }
        Rule newRule = new Rule();
        boolean insertRule = false;
        Rule currentRule = null;
        Production newProduction = new Production();
        Symbol newSymbol = new Symbol();
        Symbol newTokenSeparator = new Symbol();
        int bnfString_size = bnfString.length();
        int separated = 0;
        boolean skip = false;
        boolean quoted = false;
        boolean non_terminal = false;
        StringBuffer currentBuffer = new StringBuffer(bnfString_size);
        boolean START = false;
        boolean START_RULE = true;
        int LHS_READ = 2;
        int PRODUCTION = 3;
        int START_OF_LINE = 4;
        int state = 0;
        try {
            for (int pass = 0; pass < 2; ++pass) {
                for (int i = 0; i < bnfString_size; ++i) {
                    int currentChar = i < bnfString_size ? (int)bnfString.charAt(i) : 10;
                    if (bnfString.charAt(i) == '\\') {
                        if (++i >= bnfString_size) {
                            throw new MalformedGrammarException("Escape sequence as last char is invalid");
                        }
                        if (non_terminal && bnfString.charAt(i) != '\n') {
                            throw new MalformedGrammarException("Only escaped newline allowed inside non-terminal");
                        }
                        if (bnfString.charAt(i) == '\'') {
                            currentChar = 39;
                        } else if (bnfString.charAt(i) == '\'') {
                            currentChar = 39;
                        } else if (bnfString.charAt(i) == '\\') {
                            currentChar = 92;
                        } else if (bnfString.charAt(i) == '0') {
                            currentChar = 0;
                        } else if (bnfString.charAt(i) == 'a') {
                            currentChar = 7;
                        } else if (bnfString.charAt(i) == 'b') {
                            currentChar = 8;
                        } else if (bnfString.charAt(i) == 'f') {
                            currentChar = 12;
                        } else if (bnfString.charAt(i) == 'n') {
                            currentChar = 10;
                        } else if (bnfString.charAt(i) == 'r') {
                            currentChar = 13;
                        } else if (bnfString.charAt(i) == 't') {
                            currentChar = 9;
                        } else if (bnfString.charAt(i) == 'v') {
                            currentChar = 11;
                        } else if (bnfString.charAt(i) == '\n') {
                            skip = true;
                        } else if (bnfString.charAt(i) == '\r') {
                            skip = true;
                            if (bnfString.charAt(++i) != '\n') {
                                throw new MalformedGrammarException("No newlinwe");
                            }
                        } else {
                            currentChar = bnfString.charAt(i);
                        }
                        if (!skip && pass > 0) {
                            if (currentBuffer.length() == 0) {
                                newSymbol = new Symbol();
                                newSymbol.setType(Enums.SymbolType.TSymbol);
                            }
                            currentBuffer.append((char)currentChar);
                        }
                    } else {
                        block1 : switch (state) {
                            case 0: {
                                if (currentChar == 13) break;
                                if (currentChar == 35) {
                                    while (i < bnfString_size && bnfString.charAt(i) != '\n') {
                                        ++i;
                                    }
                                    break;
                                }
                                switch (currentChar) {
                                    case 9: 
                                    case 10: 
                                    case 32: {
                                        break block1;
                                    }
                                    case 60: {
                                        newSymbol = new Symbol();
                                        newSymbol.setType(Enums.SymbolType.NTSymbol);
                                        currentBuffer.append((char)currentChar);
                                        state = 1;
                                        break block1;
                                    }
                                }
                                throw new MalformedGrammarException("Illegal character `" + (char)currentChar + "' found at start of grammar");
                            }
                            case 1: {
                                String symbolString;
                                if (currentChar == 13) break;
                                switch (currentChar) {
                                    case 10: {
                                        throw new MalformedGrammarException("Misplaced newline");
                                    }
                                    case 62: {
                                        currentBuffer.append((char)currentChar);
                                        symbolString = currentBuffer.toString();
                                        if (pass == 0) {
                                            if (this.findRule(newSymbol) == null) {
                                                insertRule = true;
                                                newRule.setLHS(new Symbol(symbolString, Enums.SymbolType.NTSymbol));
                                            } else {
                                                insertRule = true;
                                            }
                                        } else {
                                            currentRule = this.findRule(symbolString);
                                            if (currentRule == null) {
                                                throw new MalformedGrammarException("Current rule is null: " + symbolString);
                                            }
                                        }
                                        currentBuffer.delete(0, currentBuffer.length());
                                        state = 2;
                                        break block1;
                                    }
                                }
                                if (currentChar == 34 || currentChar == 124 || currentChar == 60) {
                                    throw new MalformedGrammarException("Non escaped special character");
                                }
                                currentBuffer.append((char)currentChar);
                                break;
                            }
                            case 2: {
                                if (currentChar == 13) break;
                                switch (currentChar) {
                                    case 9: 
                                    case 10: 
                                    case 32: {
                                        break block1;
                                    }
                                    case 58: {
                                        currentBuffer.append((char)currentChar);
                                        break block1;
                                    }
                                    case 61: {
                                        currentBuffer.append((char)currentChar);
                                        String s = currentBuffer.toString();
                                        if (s.compareTo("::=") != 0) {
                                            throw new MalformedGrammarException("Something other than ::= was read");
                                        }
                                        currentBuffer.delete(0, currentBuffer.length());
                                        newProduction.clear();
                                        state = 3;
                                        break block1;
                                    }
                                }
                                throw new MalformedGrammarException("Illegal character `" + (char)currentChar + "' found in ::= token");
                            }
                            case 3: {
                                String symbolString;
                                if (currentChar == 13) break;
                                if (pass == 0) {
                                    if (currentChar != 10) break;
                                    state = 4;
                                    break;
                                }
                                switch (currentChar) {
                                    case 124: {
                                        if (quoted) {
                                            currentBuffer.append((char)currentChar);
                                            break;
                                        }
                                    }
                                    case 10: {
                                        Rule tempRule;
                                        separated = 0;
                                        if (currentBuffer.length() != 0 || newProduction.size() == 0) {
                                            if (currentBuffer.length() == 0) {
                                                newSymbol.setType(Enums.SymbolType.TSymbol);
                                            }
                                            if (non_terminal) {
                                                throw new MalformedGrammarException("Current non-terminal symbol isn't finished");
                                            }
                                            symbolString = currentBuffer.toString();
                                            newSymbol.setSymbolString(symbolString);
                                            if (newSymbol.getType() == Enums.SymbolType.NTSymbol) {
                                                tempRule = this.findRule(newSymbol);
                                                if (tempRule != null) {
                                                    newProduction.add(new Symbol(newSymbol));
                                                } else {
                                                    newProduction.add(new Symbol(newSymbol));
                                                }
                                            } else {
                                                newProduction.add(new Symbol(newSymbol));
                                            }
                                            newSymbol.clear();
                                        }
                                        currentRule.add(new Production(newProduction));
                                        currentBuffer.delete(0, currentBuffer.length());
                                        if (currentChar == 10) {
                                            state = 4;
                                            break;
                                        }
                                        newProduction.clear();
                                        break;
                                    }
                                    case 9: 
                                    case 32: 
                                    case 60: 
                                    case 62: {
                                        Rule tempRule;
                                        if (quoted || (currentChar == 32 || currentChar == 9) && non_terminal) {
                                            currentBuffer.append((char)currentChar);
                                            if (non_terminal) break block1;
                                            newSymbol.setType(Enums.SymbolType.TSymbol);
                                            break;
                                        }
                                        if (currentChar == 62) {
                                            currentBuffer.append((char)currentChar);
                                            non_terminal = false;
                                        }
                                        if (currentBuffer.length() != 0) {
                                            if (non_terminal) {
                                                throw new MalformedGrammarException("Current non-terminal symbol isn't finished");
                                            }
                                            if (currentChar == 32 || currentChar == 9) {
                                                separated = 1;
                                            }
                                            symbolString = currentBuffer.toString();
                                            newSymbol.setSymbolString(symbolString);
                                            if (newSymbol.getType() == Enums.SymbolType.NTSymbol) {
                                                tempRule = this.findRule(newSymbol);
                                                if (tempRule != null) {
                                                    newProduction.add(new Symbol(newSymbol));
                                                } else {
                                                    newProduction.add(new Symbol(newSymbol));
                                                }
                                            } else {
                                                newProduction.add(new Symbol(newSymbol));
                                            }
                                            newSymbol.clear();
                                        } else if ((currentChar == 32 || currentChar == 9) && newProduction.size() != 0) {
                                            separated = 1;
                                        }
                                        currentBuffer.delete(0, currentBuffer.length());
                                        if (currentChar != 60) break block1;
                                        newSymbol.clear();
                                        newSymbol.setType(Enums.SymbolType.NTSymbol);
                                        currentBuffer.append((char)currentChar);
                                        non_terminal = true;
                                        if (separated != 49) break block1;
                                        separated = 0;
                                        newTokenSeparator.clear();
                                        newTokenSeparator.setSymbolString(" ");
                                        newTokenSeparator.setType(Enums.SymbolType.TSymbol);
                                        newProduction.add(new Symbol(newTokenSeparator));
                                        break;
                                    }
                                    default: {
                                        if (separated == 49) {
                                            separated = 0;
                                            newTokenSeparator.clear();
                                            newTokenSeparator.setSymbolString(" ");
                                            newTokenSeparator.setType(Enums.SymbolType.TSymbol);
                                            newProduction.add(new Symbol(newTokenSeparator));
                                        }
                                        if (currentChar == 34) {
                                            quoted = !quoted;
                                            newSymbol.setType(Enums.SymbolType.TSymbol);
                                            break;
                                        }
                                        if (currentBuffer.length() == 0) {
                                            newSymbol.setType(Enums.SymbolType.TSymbol);
                                        }
                                        currentBuffer.append((char)currentChar);
                                        break;
                                    }
                                }
                                break;
                            }
                            case 4: {
                                if (currentChar == 35) {
                                    while (i < bnfString_size && bnfString.charAt(i) != '\n') {
                                        ++i;
                                    }
                                    break;
                                }
                                if (currentChar == 13) break;
                                switch (currentChar) {
                                    case 9: 
                                    case 10: 
                                    case 32: {
                                        break block1;
                                    }
                                    case 124: {
                                        state = 3;
                                        if (pass != 1) break block1;
                                        newProduction.clear();
                                        break block1;
                                    }
                                    case 60: {
                                        if (pass == 0 && insertRule) {
                                            this.rules.add(new Rule(newRule));
                                        }
                                        newSymbol.setType(Enums.SymbolType.NTSymbol);
                                        currentBuffer.append((char)currentChar);
                                        state = 1;
                                        break block1;
                                    }
                                    default: {
                                        throw new MalformedGrammarException("Illegal character `" + (char)currentChar + "' found at start of line");
                                    }
                                }
                            }
                            default: {
                                throw new MalformedGrammarException("Impossible error, quit the program now!");
                            }
                        }
                    }
                    skip = false;
                }
                if (state != 4) {
                    throw new MalformedGrammarException("START_OF_LINE must be the state of the parser");
                }
                if (pass != 0 || !insertRule) continue;
                this.rules.add(new Rule(newRule));
            }
            this.checkInfiniteRecursion();
        }
        catch (MalformedGrammarException ex) {
            this.setValidGrammar(false);
            System.out.println(ex);
            ex.printStackTrace();
            return false;
        }
        this.updateRuleFields();
        this.setValidGrammar(true);
        this.genotype2Phenotype();
        return true;
    }

    public Rule findRule(Symbol s) {
        assert (s != null) : "Symbol in findRule is:" + s;
        for (Rule r : this.rules) {
            if (!r.getLHS().equals(s)) continue;
            return r;
        }
        return null;
    }

    public Rule findRule(String s) {
        for (Rule r : this.rules) {
            if (!r.getLHS().equals(s)) continue;
            return r;
        }
        return null;
    }

    void updateRuleFields() {
        ArrayList<Rule> visitedRules = new ArrayList<Rule>();
        Iterator ruleIt = this.rules.iterator();
        this.clearRuleFields();
        while (ruleIt.hasNext()) {
            Rule r = (Rule)ruleIt.next();
            visitedRules.clear();
            r.setRecursive(this.isRecursive(visitedRules, r));
        }
        for (Rule r : this.rules) {
            visitedRules.clear();
            this.calculateMinimumDepthRecursive(r, visitedRules);
        }
        for (Rule r : this.rules) {
            visitedRules.clear();
            this.setProductionMinimumDepth(r);
        }
    }

    void setProductionMinimumDepth(Rule r) {
        Iterator pIt = r.iterator();
        while (pIt.hasNext()) {
            int minDepth = 0;
            Production prod = (Production)pIt.next();
            for (Symbol sym : prod) {
                Rule rule;
                if (sym.getType() != Enums.SymbolType.NTSymbol || (rule = this.findRule(sym)) == null || rule.getMinimumDepth() <= minDepth) continue;
                minDepth = rule.getMinimumDepth();
            }
            prod.setMinimumDepth(minDepth);
        }
    }

    void clearRuleFields() {
        for (Rule r : this.rules) {
            r.setMinimumDepth(0x3FFFFFFF);
            r.setRecursive(false);
        }
    }

    void calculateMinimumDepthRecursive(Rule startRule, ArrayList<Rule> visitedRules) {
        if (!visitedRules.contains(startRule)) {
            for (Production tempProd : startRule) {
                tempProd.setMinimumDepth(0);
                for (Symbol tempSymbol : tempProd) {
                    if (tempSymbol.getType() == Enums.SymbolType.NTSymbol) {
                        Rule currentRule = this.findRule(tempSymbol);
                        if (currentRule == null) continue;
                        visitedRules.add(startRule);
                        this.calculateMinimumDepthRecursive(currentRule, visitedRules);
                        if (tempProd.getMinimumDepth() >= currentRule.getMinimumDepth() + 1) continue;
                        tempProd.setMinimumDepth(currentRule.getMinimumDepth() + 1);
                        continue;
                    }
                    if (tempProd.getMinimumDepth() >= 1) continue;
                    tempProd.setMinimumDepth(1);
                }
                if (startRule.getMinimumDepth() <= tempProd.getMinimumDepth()) continue;
                startRule.setMinimumDepth(tempProd.getMinimumDepth());
            }
        }
    }

    public ArrayList getTerminalRules() {
        ArrayList<Symbol> terminalRules = new ArrayList<Symbol>();
        for (Rule r : this.getRules()) {
            boolean terminal = true;
            for (int i = 0; i < r.size(); ++i) {
                if (((Production)r.get(i)).getNTSymbols() <= 0) continue;
                terminal = false;
            }
            if (!terminal) continue;
            terminalRules.add(r.getLHS());
        }
        return terminalRules;
    }

    public ArrayList getNonTerminalRules() {
        ArrayList<Symbol> nonTerminalRules = new ArrayList<Symbol>();
        for (Rule r : this.getRules()) {
            boolean terminal = true;
            for (int i = 0; i < r.size(); ++i) {
                if (((Production)r.get(i)).getNTSymbols() <= 0) continue;
                terminal = false;
            }
            if (terminal) continue;
            nonTerminalRules.add(r.getLHS());
        }
        return nonTerminalRules;
    }

    private void checkInfiniteRecursion() throws MalformedGrammarException {
        for (Rule r : this.rules) {
            if (!this.isInfinitelyRecursive(r)) continue;
            throw new MalformedGrammarException("Infinite recursion: " + r);
        }
    }

    private boolean isInfinitelyRecursive(Rule startRule) throws MalformedGrammarException {
        Queue<Rule> rulesToVisit = new Queue<Rule>();
        ArrayList<Rule> visitedRules = new ArrayList<Rule>();
        rulesToVisit.enqueue(startRule);
        while (!rulesToVisit.isEmpty()) {
            Rule currentRule = (Rule)rulesToVisit.dequeue();
            Iterator prodIt = currentRule.iterator();
            visitedRules.add(currentRule);
            while (prodIt.hasNext()) {
                for (Symbol tempSymbol : (Production)prodIt.next()) {
                    if (tempSymbol.getType() == Enums.SymbolType.NTSymbol && !tempSymbol.getSymbolString().startsWith(Constants.GE_CODON_VALUE_PARSING)) {
                        currentRule = this.findRule(tempSymbol);
                        if (currentRule == null) {
                            throw new MalformedGrammarException("No rule found for symbol " + tempSymbol.toString());
                        }
                        if (visitedRules.contains(currentRule)) continue;
                        rulesToVisit.enqueue(currentRule);
                        continue;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    boolean isRecursive(ArrayList<Rule> visitedRules, Rule currentRule) {
        Iterator prodIt = visitedRules.size() == 0 ? currentRule.iterator() : visitedRules.get(visitedRules.size() - 1).iterator();
        if (visitedRules.contains(this.findRule(currentRule.getLHS()))) {
            currentRule.setRecursive(true);
            return true;
        }
        while (prodIt.hasNext()) {
            Production tempProd = (Production)prodIt.next();
            for (Symbol tempSymbol : tempProd) {
                Rule definingRule;
                if (tempSymbol.getType() != Enums.SymbolType.NTSymbol || (definingRule = this.findRule(tempSymbol)) == null || visitedRules.contains(definingRule)) continue;
                visitedRules.add(definingRule);
                if (!this.isRecursive(visitedRules, currentRule)) continue;
                tempProd.setRecursive(true);
                return true;
            }
        }
        return false;
    }
}

