/*
 * Decompiled with CFR 0.152.
 */
package Main.Tutorials;

import Algorithm.MyFirstSearchEngine;
import Algorithm.SimplePipeline;
import FitnessEvaluation.FitnessFunction;
import Main.AbstractRun;
import Mapper.GEGrammar;
import Operator.CrossoverModule;
import Operator.FitnessEvaluator;
import Operator.JoinOperator;
import Operator.MutationOperator;
import Operator.Operations.FitnessEvaluationOperation;
import Operator.Operations.IntFlipMutation;
import Operator.Operations.ReplacementOperation;
import Operator.Operations.SelectionOperation;
import Operator.Operations.SinglePointCrossover;
import Operator.SelectionScheme;
import Util.Random.MersenneTwisterFast;

public class Tutorial7
extends AbstractRun {
    public Tutorial7() {
        this.rng = new MersenneTwisterFast();
        this.propertiesFilePath = "../param/Parameters/Tutorials/Tutorial7.properties";
    }

    public void setup() {
    }

    @Override
    public void experiment(String[] args) {
        try {
            if (this.commandLineArgs(args)) {
                long st = System.currentTimeMillis();
                this.setup(args);
                this.init();
                int its = this.run();
                this.printStuff();
                long et = System.currentTimeMillis();
                System.out.println("Done running: Total time(Ms) for " + its + " generations was:" + (et - st));
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void setup(String[] args) {
        this.readProperties(args);
        GEGrammar grammar = new GEGrammar(this.properties);
        MyFirstSearchEngine alg = new MyFirstSearchEngine();
        this.initialiser = this.getInitialiser(grammar, this.rng, this.properties);
        SinglePointCrossover singlePointCrossover = new SinglePointCrossover(this.rng, this.properties);
        CrossoverModule crossoverModule = new CrossoverModule(this.rng, singlePointCrossover);
        IntFlipMutation mutation = new IntFlipMutation(this.rng, this.properties);
        MutationOperator mutationModule = new MutationOperator(this.rng, mutation);
        SelectionOperation selectionOperation = this.getSelectionOperation(this.properties, this.rng);
        SelectionScheme selectionScheme = new SelectionScheme(this.rng, selectionOperation);
        ReplacementOperation replacementOperation = new ReplacementOperation(this.properties);
        JoinOperator replacementStrategy = this.getJoinOperator(this.properties, this.rng, selectionScheme.getPopulation(), replacementOperation);
        FitnessFunction fitnessFunction = this.getFitnessFunction(this.properties);
        FitnessEvaluationOperation fitnessEvaluationOperation = new FitnessEvaluationOperation(fitnessFunction);
        FitnessEvaluator fitnessEvaluator = new FitnessEvaluator(this.rng, fitnessEvaluationOperation);
        SimplePipeline pipelineInit = new SimplePipeline();
        alg.setInitPipeline(pipelineInit);
        FitnessEvaluator fitnessEvaluatorInit = new FitnessEvaluator(this.rng, fitnessEvaluationOperation);
        fitnessEvaluatorInit.setPopulation(this.initialiser.getPopulation());
        pipelineInit.addModule(this.initialiser);
        pipelineInit.addModule(fitnessEvaluatorInit);
        SimplePipeline pipelineLoop = new SimplePipeline();
        alg.setLoopPipeline(pipelineLoop);
        selectionScheme.setPopulation(this.initialiser.getPopulation());
        replacementStrategy.setPopulation(this.initialiser.getPopulation());
        crossoverModule.setPopulation(selectionScheme.getPopulation());
        mutationModule.setPopulation(selectionScheme.getPopulation());
        fitnessEvaluator.setPopulation(selectionScheme.getPopulation());
        pipelineLoop.addModule(selectionScheme);
        pipelineLoop.addModule(crossoverModule);
        pipelineLoop.addModule(mutationModule);
        pipelineLoop.addModule(fitnessEvaluator);
        pipelineLoop.addModule(replacementStrategy);
        this.algorithm = alg;
    }

    public static void main(String[] args) {
        Tutorial7 mainTutorial7 = new Tutorial7();
        mainTutorial7.experiment(args);
        System.exit(0);
    }
}

