/*
 * Decompiled with CFR 0.152.
 */
package Main.Tutorials;

import Algorithm.MyFirstSearchEngine;
import Algorithm.SimplePipeline;
import FitnessEvaluation.FitnessFunction;
import Main.AbstractRun;
import Mapper.GEGrammar;
import Operator.Collector;
import Operator.CrossoverModule;
import Operator.FitnessEvaluator;
import Operator.JoinOperator;
import Operator.MutationOperator;
import Operator.Operations.FitnessEvaluationOperation;
import Operator.Operations.IntFlipMutation;
import Operator.Operations.ReplacementOperation;
import Operator.Operations.SelectionOperation;
import Operator.Operations.SinglePointCrossover;
import Operator.Operations.StatisticsCollectionOperation;
import Operator.SelectionScheme;
import Util.Random.MersenneTwisterFast;
import Util.Statistics.IndividualCatcher;
import Util.Statistics.StatCatcher;

public class Tutorial6
extends AbstractRun {
    private long startTime;

    public Tutorial6() {
        this.rng = new MersenneTwisterFast();
        this.propertiesFilePath = "../param/Parameters/Tutorials/Tutorial6.properties";
        this.startTime = System.currentTimeMillis();
    }

    public void setup() {
    }

    @Override
    public void experiment(String[] args) {
        try {
            if (this.commandLineArgs(args)) {
                long st = System.currentTimeMillis();
                this.setup(args);
                this.init();
                int its = this.run();
                this.printStuff();
                long et = System.currentTimeMillis();
                System.out.println("Done running: Total time(Ms) for " + its + " generations was:" + (et - st));
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void setup(String[] args) {
        this.readProperties(args);
        GEGrammar grammar = new GEGrammar(this.properties);
        MyFirstSearchEngine alg = new MyFirstSearchEngine();
        this.initialiser = this.getInitialiser(grammar, this.rng, this.properties);
        SinglePointCrossover singlePointCrossover = new SinglePointCrossover(this.rng, this.properties);
        CrossoverModule crossoverModule = new CrossoverModule(this.rng, singlePointCrossover);
        IntFlipMutation mutation = new IntFlipMutation(this.rng, this.properties);
        MutationOperator mutationModule = new MutationOperator(this.rng, mutation);
        SelectionOperation selectionOperation = this.getSelectionOperation(this.properties, this.rng);
        SelectionScheme selectionScheme = new SelectionScheme(this.rng, selectionOperation);
        ReplacementOperation replacementOperation = new ReplacementOperation(this.properties);
        JoinOperator replacementStrategy = this.getJoinOperator(this.properties, this.rng, selectionScheme.getPopulation(), replacementOperation);
        FitnessFunction fitnessFunction = this.getFitnessFunction(this.properties);
        FitnessEvaluationOperation fitnessEvaluationOperation = new FitnessEvaluationOperation(fitnessFunction);
        FitnessEvaluator fitnessEvaluator = new FitnessEvaluator(this.rng, fitnessEvaluationOperation);
        StatCatcher stats = new StatCatcher(Integer.parseInt(this.properties.getProperty("generations")));
        IndividualCatcher indCatch = new IndividualCatcher(this.properties);
        stats.addTime(this.startTime);
        StatisticsCollectionOperation statsCollection = new StatisticsCollectionOperation(stats, indCatch, this.properties);
        Collector collector = new Collector(statsCollection);
        SimplePipeline pipelineInit = new SimplePipeline();
        alg.setInitPipeline(pipelineInit);
        FitnessEvaluator fitnessEvaluatorInit = new FitnessEvaluator(this.rng, fitnessEvaluationOperation);
        fitnessEvaluatorInit.setPopulation(this.initialiser.getPopulation());
        collector.setPopulation(this.initialiser.getPopulation());
        pipelineInit.addModule(this.initialiser);
        pipelineInit.addModule(fitnessEvaluatorInit);
        pipelineInit.addModule(collector);
        SimplePipeline pipelineLoop = new SimplePipeline();
        alg.setLoopPipeline(pipelineLoop);
        selectionScheme.setPopulation(this.initialiser.getPopulation());
        replacementStrategy.setPopulation(this.initialiser.getPopulation());
        crossoverModule.setPopulation(selectionScheme.getPopulation());
        mutationModule.setPopulation(selectionScheme.getPopulation());
        fitnessEvaluator.setPopulation(selectionScheme.getPopulation());
        collector.setPopulation(this.initialiser.getPopulation());
        pipelineLoop.addModule(selectionScheme);
        pipelineLoop.addModule(crossoverModule);
        pipelineLoop.addModule(mutationModule);
        pipelineLoop.addModule(fitnessEvaluator);
        pipelineLoop.addModule(replacementStrategy);
        pipelineLoop.addModule(collector);
        this.algorithm = alg;
    }

    public static void main(String[] args) {
        Tutorial6 mainTutorial6 = new Tutorial6();
        mainTutorial6.experiment(args);
        System.exit(0);
    }
}

