/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Algorithm.MyFirstSearchEngine;
import Algorithm.SimplePipeline;
import FitnessEvaluation.FitnessFunction;
import Main.AbstractRun;
import Mapper.GEGrammar;
import Operator.Collector;
import Operator.CrossoverModule;
import Operator.EliteReplacementOperator;
import Operator.FitnessEvaluator;
import Operator.JoinOperator;
import Operator.MutationOperator;
import Operator.Operations.EliteOperationSelection;
import Operator.Operations.EliteReplacementOperation;
import Operator.Operations.FitnessEvaluationOperation;
import Operator.Operations.MutationOperation;
import Operator.Operations.ReplacementOperation;
import Operator.Operations.SelectionOperation;
import Operator.Operations.SinglePointCrossover;
import Operator.Operations.StatisticsCollectionOperation;
import Operator.SelectionScheme;
import Util.Random.MersenneTwisterFast;
import Util.Statistics.IndividualCatcher;
import Util.Statistics.StatCatcher;

public class Run
extends AbstractRun {
    private long startTime;

    public Run() {
        this.rng = new MersenneTwisterFast();
        this.propertiesFilePath = "../param/Parameters/HelloWorld.properties";
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void experiment(String[] args) {
        try {
            if (this.commandLineArgs(args)) {
                long st = System.currentTimeMillis();
                this.setup(args);
                this.init();
                int its = this.run();
                this.printStuff();
                long et = System.currentTimeMillis();
                System.out.println("Done running: Total time(Ms) for " + its + " generations was:" + (et - st));
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void setup(String[] args) {
        this.readProperties(args);
        this.setSeed();
        GEGrammar grammar = this.getGEGrammar(this.properties);
        MyFirstSearchEngine alg = new MyFirstSearchEngine();
        this.initialiser = this.getInitialiser(grammar, this.rng, this.properties);
        SinglePointCrossover singlePointCrossover = new SinglePointCrossover(this.rng, this.properties);
        CrossoverModule crossoverModule = new CrossoverModule(this.rng, singlePointCrossover);
        MutationOperation mutation = this.getMutationOperation(this.rng, this.properties);
        MutationOperator mutationModule = new MutationOperator(this.rng, mutation);
        SelectionOperation selectionOperation = this.getSelectionOperation(this.properties, this.rng);
        SelectionScheme selectionScheme = new SelectionScheme(this.rng, selectionOperation);
        ReplacementOperation replacementOperation = new ReplacementOperation(this.properties);
        JoinOperator replacementStrategy = this.getJoinOperator(this.properties, this.rng, selectionScheme.getPopulation(), replacementOperation);
        EliteOperationSelection eliteSelectionOperation = new EliteOperationSelection(this.properties);
        SelectionScheme eliteSelection = new SelectionScheme(this.rng, eliteSelectionOperation);
        EliteReplacementOperation eliteReplacementOperation = new EliteReplacementOperation(this.properties);
        EliteReplacementOperator eliteReplacementStrategy = new EliteReplacementOperator(this.rng, eliteSelection.getPopulation(), eliteReplacementOperation);
        FitnessFunction fitnessFunction = this.getFitnessFunction(this.properties);
        FitnessEvaluationOperation fitnessEvaluationOperation = new FitnessEvaluationOperation(fitnessFunction);
        fitnessEvaluationOperation.setProperties(this.properties);
        FitnessEvaluator fitnessEvaluator = new FitnessEvaluator(this.rng, fitnessEvaluationOperation);
        StatCatcher stats = new StatCatcher(Integer.parseInt(this.properties.getProperty("generations")));
        IndividualCatcher indCatch = new IndividualCatcher(this.properties);
        stats.addTime(this.startTime);
        StatisticsCollectionOperation statsCollection = new StatisticsCollectionOperation(stats, indCatch, this.properties);
        this.collector = new Collector(statsCollection);
        SimplePipeline pipelineInit = new SimplePipeline();
        alg.setInitPipeline(pipelineInit);
        FitnessEvaluator fitnessEvaluatorInit = new FitnessEvaluator(this.rng, fitnessEvaluationOperation);
        fitnessEvaluatorInit.setPopulation(this.initialiser.getPopulation());
        this.collector.setPopulation(this.initialiser.getPopulation());
        pipelineInit.addModule(this.initialiser);
        pipelineInit.addModule(fitnessEvaluatorInit);
        pipelineInit.addModule(this.collector);
        SimplePipeline pipelineLoop = new SimplePipeline();
        alg.setLoopPipeline(pipelineLoop);
        selectionScheme.setPopulation(this.initialiser.getPopulation());
        replacementStrategy.setPopulation(this.initialiser.getPopulation());
        crossoverModule.setPopulation(selectionScheme.getPopulation());
        mutationModule.setPopulation(selectionScheme.getPopulation());
        fitnessEvaluator.setPopulation(selectionScheme.getPopulation());
        eliteSelection.setPopulation(this.initialiser.getPopulation());
        eliteReplacementStrategy.setPopulation(this.initialiser.getPopulation());
        this.collector.setPopulation(this.initialiser.getPopulation());
        pipelineLoop.addModule(eliteSelection);
        pipelineLoop.addModule(selectionScheme);
        pipelineLoop.addModule(crossoverModule);
        pipelineLoop.addModule(mutationModule);
        pipelineLoop.addModule(fitnessEvaluator);
        pipelineLoop.addModule(replacementStrategy);
        pipelineLoop.addModule(eliteReplacementStrategy);
        pipelineLoop.addModule(this.collector);
        this.algorithm = alg;
    }

    private void setSeed() {
        if (this.properties.getProperty("rng_seed") != null) {
            long seed = Long.parseLong(this.properties.getProperty("rng_seed"));
            this.rng.setSeed(seed);
        }
    }

    public static void main(String[] args) {
        Run mainRun = new Run();
        mainRun.experiment(args);
        System.exit(0);
    }
}

