/*
 * Decompiled with CFR 0.152.
 */
package Individuals.Populations;

import Individuals.AbstractIndividual;
import Individuals.Individual;
import Individuals.Populations.Population;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SimplePopulation
implements Population {
    ArrayList<Individual> indies;

    public SimplePopulation() {
        this.indies = new ArrayList();
    }

    public SimplePopulation(int size) {
        this.indies = new ArrayList(size);
    }

    @Override
    public void add(Individual i) {
        this.indies.add(i);
    }

    @Override
    public void sort() {
        Collections.sort(this.indies);
    }

    @Override
    public Iterator<Individual> iterator() {
        return this.indies.iterator();
    }

    @Override
    public int size() {
        return this.indies.size();
    }

    @Override
    public void addAll(Collection<Individual> immigrants) {
        for (Individual immigrant : immigrants) {
            this.indies.add(immigrant);
        }
    }

    @Override
    public void addAll(Population immigrants) {
        Iterator<Individual> indIt = immigrants.iterator();
        while (indIt.hasNext()) {
            this.indies.add(indIt.next());
        }
    }

    @Override
    public List<Individual> getAll() {
        return this.indies;
    }

    public boolean contains(AbstractIndividual individual) {
        return this.indies.contains(individual);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator<Individual> iIt = this.indies.iterator();
        DecimalFormat df = new DecimalFormat("#0.00");
        while (iIt.hasNext()) {
            Individual ind = iIt.next();
            String f = df.format(ind.getFitness().getDouble());
            s.append(f);
            if (!iIt.hasNext()) continue;
            s.append(",");
        }
        return s.toString();
    }

    @Override
    public boolean contains(Individual individual) {
        return this.indies.contains(individual);
    }

    @Override
    public Individual get(int index) {
        return this.indies.get(index);
    }

    @Override
    public void clear() {
        this.indies.clear();
    }

    @Override
    public void remove(Individual ind) {
        this.indies.remove(ind);
    }

    public Individual set(int i, Individual ind) {
        return this.indies.set(i, ind);
    }
}

