/*
 * Decompiled with CFR 0.152.
 */
package Individuals;

import Individuals.AbstractIndividual;
import Individuals.FitnessPackage.BasicFitness;
import Individuals.FitnessPackage.Fitness;
import Individuals.GEChromosome;
import Individuals.Genotype;
import Individuals.Individual;
import Individuals.Phenotype;
import Mapper.GEGrammar;
import Mapper.Mapper;
import java.util.ArrayList;

public class GEIndividual
extends AbstractIndividual {
    private Genotype genotype;
    private Phenotype phenotype;
    private GEGrammar grammar;
    private boolean mapped;
    private boolean valid;
    private int usedCodons;
    private int usedWraps;
    private int previouslyUsedCodons;
    private boolean previouslyValid;
    int[] mutationPoints;
    int[] crossoverPoints;
    ArrayList<Fitness> parentsFitness;

    public GEIndividual() {
        this.mapped = false;
        this.valid = false;
        this.previouslyValid = false;
        this.usedCodons = -1;
        this.usedWraps = -1;
    }

    public GEIndividual(GEGrammar g, Phenotype p, Genotype gen, Fitness f) {
        this.grammar = GEGrammar.getGrammar(g);
        this.phenotype = p;
        this.genotype = gen;
        this.fitness = f;
        this.evaluated = false;
        this.mapped = false;
        this.valid = false;
        this.previouslyValid = false;
        this.usedCodons = -1;
        this.usedWraps = -1;
        this.grammar.setPhenotype(this.phenotype);
        this.grammar.setGenotype(this.genotype.get(0));
        this.fitness.setIndividual(this);
        this.age = 0;
        this.mutationPoints = null;
        this.crossoverPoints = null;
        this.parentsFitness = null;
    }

    private GEIndividual(GEIndividual i) {
        super(i);
        this.grammar = GEGrammar.getGrammar(i.grammar);
        this.phenotype = new Phenotype(i.phenotype);
        if (i.getGenotype() != null) {
            this.genotype = new Genotype(1);
            this.genotype.add(new GEChromosome((GEChromosome)i.getGenotype().get(0)));
            this.grammar.setGenotype(this.genotype.get(0));
        }
        this.crossoverPoints = null;
        this.mutationPoints = null;
        if (i.parentsFitness != null) {
            this.parentsFitness = new ArrayList(i.parentsFitness.size());
            for (Fitness f : i.parentsFitness) {
                this.parentsFitness.add(new BasicFitness(i));
            }
        }
        this.fitness = new BasicFitness(i.fitness.getDouble(), this);
        this.grammar.setPhenotype(this.phenotype);
    }

    public static GEIndividual getIndividual(GEGrammar grammar, Phenotype phen, Genotype genotype, Fitness fitness) {
        GEIndividual gei = new GEIndividual(grammar, phen, genotype, fitness);
        return gei;
    }

    public void revalidate(GEIndividual ind) {
        this.setMapped(ind.isMapped());
        this.setEvaluated(ind.isEvaluated());
        this.setUsedCodons(ind.getUsedCodons());
        this.setUsedWraps(ind.getUsedWraps());
        this.setValid(ind.isValid());
        this.setAge(ind.getAge());
    }

    public void invalidate() {
        this.usedCodons = -1;
        this.usedWraps = -1;
        this.valid = false;
        this.mapped = false;
        this.evaluated = false;
        this.age = 1;
    }

    public boolean isMapped() {
        return this.mapped;
    }

    public void setMapped(boolean mapped) {
        this.mapped = mapped;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean b) {
        this.valid = b;
        this.previouslyValid = b;
    }

    public boolean wasPreviouslyValid() {
        return this.previouslyValid;
    }

    public void setUsedCodons(int usedCodons) {
        this.usedCodons = usedCodons;
    }

    public void setUsedWraps(int usedWraps) {
        this.usedWraps = usedWraps;
    }

    @Override
    public void map(int map) {
        if (!this.mapped) {
            this.phenotype.clear();
            this.previouslyValid = this.valid = this.grammar.genotype2Phenotype(true);
            this.mapped = true;
            this.usedCodons = this.grammar.getUsedCodons();
            this.usedWraps = this.grammar.getUsedWraps();
        }
    }

    @Override
    public String getPhenotypeString(int map) {
        return this.phenotype.getString();
    }

    @Override
    public Genotype getGenotype() {
        return this.genotype;
    }

    @Override
    public Mapper getMapper() {
        return this.grammar;
    }

    @Override
    public void setMapper(Mapper m) {
        this.grammar = (GEGrammar)m;
    }

    @Override
    public void setGenotype(Genotype g) {
        this.invalidate();
        this.genotype = g;
        this.getMapper().setGenotype(this.genotype.get(0));
    }

    @Override
    public void setPhenotype(Phenotype p) {
        this.phenotype = p;
    }

    @Override
    public Phenotype getPhenotype() {
        return this.phenotype;
    }

    @Override
    public Individual clone() {
        GEIndividual ind = new GEIndividual(this);
        ind.setPreviouslyUsedCodons(this.usedCodons);
        ind.invalidate();
        return ind;
    }

    public String toString() {
        String s = "";
        if (this.phenotype != null) {
            s = this.phenotype.getString();
        }
        return s;
    }

    public int getUsedCodons() {
        return this.usedCodons;
    }

    public void setPreviouslyUsedCodons(int previouslyUsedCodons) {
        this.previouslyUsedCodons = previouslyUsedCodons;
    }

    public int getPreviouslyUsedCodons() {
        return this.previouslyUsedCodons;
    }

    public int getUsedWraps() {
        return this.usedWraps;
    }

    public int[] getCrossoverPoints() {
        return this.crossoverPoints;
    }

    public int[] getMutationPoints() {
        return this.mutationPoints;
    }

    public ArrayList<Fitness> getParents() {
        return this.parentsFitness;
    }

    public void setCrossoverPoints(int[] crossoverPoints) {
        this.crossoverPoints = crossoverPoints;
    }

    public void setMutationPoints(int[] mutationPoints) {
        this.mutationPoints = mutationPoints;
    }

    public void setParents(ArrayList<Fitness> parents) {
        this.parentsFitness = parents;
    }
}

