/*
 * Decompiled with CFR 0.152.
 */
package Individuals;

import Individuals.Chromosome;
import Util.Structures.IntIterator;
import Util.Structures.StaticIntList;

public class GEChromosome
extends StaticIntList
implements Chromosome {
    private static int defaultLength = 100;
    private boolean validGenotype;
    private int maxCodonValue;
    private int maxCodonValueBitSize = 32;
    private int usedGenes;
    private int usedWraps;
    int maxChromosomeLength;

    public GEChromosome() {
        super(defaultLength);
    }

    public GEChromosome(int size) {
        super(size);
    }

    public GEChromosome(int size, int[] data) {
        super(size);
        this.setAll(data);
    }

    public GEChromosome(GEChromosome c) {
        super(c);
        this.validGenotype = c.validGenotype;
        this.maxCodonValue = c.maxCodonValue;
        this.maxChromosomeLength = c.maxChromosomeLength;
    }

    public int getCodonSizeBits() {
        return this.maxCodonValueBitSize;
    }

    public int getMaxChromosomeLength() {
        return this.maxChromosomeLength;
    }

    public void setMaxChromosomeLength(int maxChromosomeLength) {
        this.maxChromosomeLength = maxChromosomeLength;
        super.setMaxSize(this.maxChromosomeLength);
    }

    public void setUsedWraps(int usedWraps) {
        this.usedWraps = usedWraps;
    }

    public int getUsedWraps() {
        return this.usedWraps;
    }

    public int getUsedGenes() {
        return this.usedGenes;
    }

    public void setUsedGenes(int usedGenes) {
        this.usedGenes = usedGenes;
    }

    public int getMaxCodonValue() {
        return this.maxCodonValue;
    }

    public int getCodonSize() {
        int intSize = (int)Math.ceil((double)this.maxCodonValueBitSize / 8.0);
        return intSize;
    }

    public void setMaxCodonValue(int maxCodonValue) {
        double mcvLog = Math.log(maxCodonValue);
        double twoLog = Math.log(2.0);
        this.maxCodonValueBitSize = maxCodonValue == Integer.MAX_VALUE ? 32 : (int)Math.ceil(mcvLog / twoLog);
        this.maxCodonValue = maxCodonValue;
    }

    @Override
    public int getLength() {
        return this.currentSize;
    }

    public boolean getValid() {
        return this.validGenotype;
    }

    public void setValid(boolean newValid) {
        this.validGenotype = newValid;
    }

    public void doubleSize() {
        if (this.getLength() < maxSize) {
            int[] newA = new int[this.getLength() * 2];
            System.arraycopy(this.data, 0, newA, 0, this.data.length);
            this.setAll(newA);
        } else {
            System.out.println("No doubling, too long");
        }
    }

    public static void setDefaultLength(int length) {
        defaultLength = length;
    }

    public static int getDefaultLength() {
        return defaultLength;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        IntIterator i = this.iterator();
        s.append("Chromosome Contents: ");
        while (i.hasNext()) {
            s.append(i.next());
            s.append(",");
        }
        return s.toString();
    }
}

