/*
 * Decompiled with CFR 0.152.
 */
package Individuals.FitnessPackage;

import Individuals.FitnessPackage.DoubleFitness;
import Individuals.FitnessPackage.Fitness;
import Individuals.Individual;

public class BasicFitness
implements Fitness {
    public static final double DEFAULT_FITNESS = 1.0E8;
    private static double Min_Double = 0.0;
    private static double Max_Double = 1.0E8;
    private static int Min_Int = 0;
    private static int Max_Int = 100000000;
    private double value;
    private Individual individual;

    public BasicFitness() {
        this.value = 0.0;
    }

    public BasicFitness(double f, Individual i) {
        this.value = f;
        this.individual = i;
    }

    public BasicFitness(Individual i) {
        this.individual = i;
    }

    @Override
    public int compareTo(Fitness o) {
        double dO = o.getDouble();
        double dT = this.value;
        if (Double.isNaN(dO) || Double.isInfinite(dO)) {
            dO = Max_Double;
        }
        if (Double.isNaN(dT) || Double.isInfinite(dT)) {
            dT = Max_Double;
        }
        if (dT < dO) {
            return -1;
        }
        if (dT > dO) {
            return 1;
        }
        return 0;
    }

    @Override
    public double getMaxDoubleFitness() {
        return Max_Double;
    }

    @Override
    public double getMinDoubleFitness() {
        return Min_Double;
    }

    @Override
    public int getMaxIntFitness() {
        return Max_Int;
    }

    @Override
    public int getMinIntFitness() {
        return Min_Int;
    }

    @Override
    public void setDefault() {
        this.value = 1.0E8;
    }

    public double getDefaultFitness() {
        return 1.0E8;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    public double getDistance(DoubleFitness f) {
        return this.value - f.getDouble();
    }

    @Override
    public Individual getIndividual() {
        return this.individual;
    }

    @Override
    public void setIndividual(Individual i) {
        this.individual = i;
    }

    @Override
    public void setDouble(double f) {
        if (Double.isNaN(f) || Double.isInfinite(f)) {
            f = Max_Double;
        }
        this.value = f;
    }

    @Override
    public int getInt() {
        return (int)this.value;
    }

    @Override
    public void setInt(int f) {
        this.value = f;
    }
}

