/*
 * Decompiled with CFR 0.152.
 */
package Individuals;

import Individuals.FitnessPackage.Fitness;
import Individuals.Genotype;
import Individuals.Individual;
import Individuals.Phenotype;
import Mapper.Mapper;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractIndividual
implements Individual {
    private final int uid = this.increaseUIDCounter();
    private static int uidCounter = 0;
    protected Fitness fitness;
    protected boolean evaluated;
    protected int age;
    protected List<Integer> parentUIDs;

    AbstractIndividual(AbstractIndividual copy) {
        ArrayList<Integer> parentUID = new ArrayList<Integer>(1);
        parentUID.add(copy.getUID());
        this.setParentUIDs(parentUID);
    }

    AbstractIndividual() {
        ArrayList<Integer> parentUID = new ArrayList<Integer>();
        this.setParentUIDs(parentUID);
    }

    @Override
    public abstract void map(int var1);

    @Override
    public abstract String getPhenotypeString(int var1);

    @Override
    public abstract Mapper getMapper();

    @Override
    public abstract Genotype getGenotype();

    @Override
    public abstract void setMapper(Mapper var1);

    @Override
    public abstract void setGenotype(Genotype var1);

    @Override
    public abstract void setPhenotype(Phenotype var1);

    @Override
    public abstract Phenotype getPhenotype();

    @Override
    public abstract Individual clone();

    @Override
    public int compareTo(Individual o) {
        return this.fitness.compareTo(o.getFitness());
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void setAge(int age) {
        this.age = age;
    }

    @Override
    public Fitness getFitness() {
        return this.fitness;
    }

    @Override
    public void setFitness(Fitness f) {
        this.fitness = f;
        f.setIndividual(this);
    }

    @Override
    public boolean isEvaluated() {
        return this.evaluated;
    }

    @Override
    public void setEvaluated(boolean b) {
        this.evaluated = b;
    }

    public int getUID() {
        return this.uid;
    }

    public int increaseUIDCounter() {
        return uidCounter++;
    }

    public void setParentUIDs(List<Integer> _parentUIDs) {
        this.parentUIDs = _parentUIDs;
    }

    public List<Integer> getParentUIDs() {
        return this.parentUIDs;
    }
}

