/*
 * Decompiled with CFR 0.152.
 */
package Fractal;

import Fractal.Cursor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import java.util.Stack;
import javax.swing.JPanel;

public class LSystem
extends JPanel {
    Dimension size;
    Image buffer;
    int xMin;
    int xMax;
    int yMin;
    int yMax;
    int width;
    int height;
    int n = 5;
    float angle = 25.7f;
    double fitness;
    String init = "F";
    String grammar = "F=F[+F]F[-F]F+F-F";
    String finalPath;

    public LSystem(String Gra, int dep, float ang, int width, double fitness) {
        this.grammar = Gra;
        this.n = dep;
        this.angle = ang;
        this.fitness = fitness;
        this.init(width);
    }

    public void init(int width) {
        this.setLayout(null);
        this.size = new Dimension(width, width);
        this.setPreferredSize(this.size);
        this.width = this.height = width;
        this.yMin = -10;
        this.xMin = -10;
        this.yMax = 10;
        this.xMax = 10;
    }

    public void getScale(String finalPath, double angle) {
        double size;
        double xMax = 0.0;
        double xMin = 0.0;
        double yMin = 0.0;
        double yMax = 0.0;
        Cursor cursor = new Cursor();
        Stack<Cursor> cursorStack = new Stack<Cursor>();
        StringReader pathReader = new StringReader(finalPath);
        try {
            block9: for (int i = 0; i < finalPath.length(); ++i) {
                int c = pathReader.read();
                switch (c) {
                    case 70: 
                    case 102: {
                        cursor.x += Math.cos(cursor.angle);
                        if (cursor.x > xMax) {
                            xMax = cursor.x;
                        } else if (cursor.x < xMin) {
                            xMin = cursor.x;
                        }
                        cursor.y += Math.sin(cursor.angle);
                        if (cursor.y > yMax) {
                            yMax = cursor.y;
                            continue block9;
                        }
                        if (!(cursor.y < yMin)) continue block9;
                        yMin = cursor.y;
                        continue block9;
                    }
                    case 43: {
                        cursor.angle += angle;
                        while (cursor.angle >= Math.PI * 2) {
                            cursor.angle -= Math.PI * 2;
                        }
                        continue block9;
                    }
                    case 45: {
                        cursor.angle -= angle;
                        while (cursor.angle < 0.0) {
                            cursor.angle += Math.PI * 2;
                        }
                        continue block9;
                    }
                    case 91: {
                        cursorStack.push(new Cursor(cursor));
                        continue block9;
                    }
                    case 93: {
                        cursor = (Cursor)cursorStack.pop();
                        continue block9;
                    }
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if ((size = xMax - xMin) < yMax - yMin) {
            size = yMax - yMin;
        }
        this.xMax = (int)((xMax + xMin) / 2.0 + size / 2.0) + 1;
        this.xMin = (int)((xMax + xMin) / 2.0 - size / 2.0) - 1;
        this.yMax = (int)((yMax + yMin) / 2.0 + size / 2.0) + 1;
        this.yMin = (int)((yMax + yMin) / 2.0 - size / 2.0) - 1;
    }

    public int getXCoord(double x) {
        float p = (float)this.width / (float)(this.xMax - this.xMin);
        return (int)((x - (double)this.xMin) * (double)p);
    }

    public int getYCoord(double y) {
        float p = (float)this.width / (float)(this.yMax - this.yMin);
        return (int)((y - (double)this.yMin) * (double)p);
    }

    public void drawPath(String finalPath, double angle, Graphics graphics) {
        Cursor cursor = new Cursor();
        Cursor newCursor = new Cursor();
        Stack<Cursor> cursorStack = new Stack<Cursor>();
        StringReader pathReader = new StringReader(finalPath);
        try {
            block10: for (int i = 0; i < finalPath.length(); ++i) {
                int c = pathReader.read();
                switch (c) {
                    case 70: {
                        newCursor.x = cursor.x + Math.cos(cursor.angle);
                        newCursor.y = cursor.y + Math.sin(cursor.angle);
                        newCursor.angle = cursor.angle;
                        graphics.drawLine(this.getXCoord(cursor.x), this.getYCoord(cursor.y), this.getXCoord(newCursor.x), this.getYCoord(newCursor.y));
                        cursor.x = newCursor.x;
                        cursor.y = newCursor.y;
                        continue block10;
                    }
                    case 102: {
                        cursor.x += Math.cos(cursor.angle);
                        cursor.y += Math.sin(cursor.angle);
                        continue block10;
                    }
                    case 43: {
                        cursor.angle += angle;
                        while (cursor.angle >= Math.PI * 2) {
                            cursor.angle -= Math.PI * 2;
                        }
                        continue block10;
                    }
                    case 45: {
                        cursor.angle -= angle;
                        while (cursor.angle < 0.0) {
                            cursor.angle += Math.PI * 2;
                        }
                        continue block10;
                    }
                    case 91: {
                        cursorStack.push(new Cursor(cursor));
                        continue block10;
                    }
                    case 93: {
                        cursor = (Cursor)cursorStack.pop();
                        continue block10;
                    }
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public String expandPath(String init, String grammar, int depth) {
        if (depth <= 0) {
            return init;
        }
        StringWriter sw = new StringWriter();
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(grammar.getBytes()));
            StringReader initReader = new StringReader(init);
            for (int i = 0; i < init.length(); ++i) {
                int c = initReader.read();
                StringWriter sw2 = new StringWriter();
                sw2.write(c);
                sw.write(props.getProperty(sw2.toString(), sw2.toString()));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (depth - 1 > 0) {
            return this.expandPath(sw.toString(), grammar, depth - 1);
        }
        return sw.toString();
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.red);
        g.fillRect(2, this.height - (int)((double)this.height * this.fitness) + 2, 5, (int)((double)this.height * this.fitness) - 4);
        g.setColor(Color.gray);
        g.drawRoundRect(0, 0, this.width - 1, this.height - 1, 5, 5);
        g.setColor(Color.green);
        String expandedPath = this.expandPath(this.init, this.grammar, this.n);
        try {
            this.getScale(expandedPath, Double.valueOf(this.angle) / 57.29577951308232);
            this.drawPath(expandedPath, Double.valueOf(this.angle) / 57.29577951308232, g);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }
}

