/*
 * Decompiled with CFR 0.152.
 */
package FitnessEvaluation.util;

import Util.Random.RandomNumberGenerator;

public class Range {
    private double[] start;
    private double[] stop;
    private double[] step;
    private boolean[] random;
    RandomNumberGenerator rng;
    private int totalSamples;

    public Range(String s) {
        this.stringToRange(s);
    }

    public Range(String s, RandomNumberGenerator rng) {
        this.stringToRange(s);
        this.rng = rng;
    }

    public void stringToRange(String s) {
        String[] sA = s.split(";");
        this.start = new double[sA.length];
        this.stop = new double[sA.length];
        this.step = new double[sA.length];
        this.random = new boolean[sA.length];
        for (int j = 0; j < sA.length; ++j) {
            String[] sA_2 = sA[j].split("\\s*eq\\s*");
            for (int i = 0; i < sA_2.length; ++i) {
                String[] sA_3;
                if (sA_2[i].contains("[")) {
                    sA_3 = sA_2[i].split(":");
                    this.start[j] = Double.parseDouble(sA_3[0].substring(1));
                    this.step[j] = Double.parseDouble(sA_3[1]);
                    this.stop[j] = Double.parseDouble(sA_3[2].substring(0, sA_3[2].length() - 1));
                    this.random[j] = false;
                    continue;
                }
                if (!sA_2[i].contains("(")) continue;
                sA_3 = sA_2[i].split(",");
                this.start[j] = Double.parseDouble(sA_3[0].substring(4));
                this.step[j] = Double.parseDouble(sA_3[1]);
                this.stop[j] = Double.parseDouble(sA_3[2].substring(0, sA_3[2].length() - 1));
                this.random[j] = true;
            }
        }
        this.totalSamples = this.getTotalSamples();
    }

    public int getTotalSamples(int i) {
        if (this.isRandom(i)) {
            return (int)this.getStep(i);
        }
        return (int)((this.getStop(i) - this.getStart(i)) / this.getStep(i));
    }

    int getTotalSamples() throws IllegalArgumentException {
        int totalSamplesTmp = this.getTotalSamples(0);
        for (int i = 1; i < this.step.length; ++i) {
            if (totalSamplesTmp == this.getTotalSamples(i)) continue;
            throw new IllegalArgumentException(this.getClass().getName() + " Samples from each dimension must be of the same size");
        }
        return totalSamplesTmp;
    }

    public double[][] getSamples() {
        double[][] samples = new double[this.totalSamples][this.getDimensions()];
        for (int i = 0; i < samples[0].length; ++i) {
            double interval = this.stop[i] - this.start[i];
            for (int j = 0; j < samples.length; ++j) {
                double value = this.random[i] ? this.rng.nextDouble() * interval : this.step[i] * (double)j;
                samples[j][i] = this.start[i] + value;
            }
        }
        return samples;
    }

    public boolean isRandom() {
        return this.random[0];
    }

    public void setRandom(boolean random) {
        this.random[0] = random;
    }

    public boolean isRandom(int i) {
        return this.random[i];
    }

    public void setRandom(boolean random, int i) {
        this.random[i] = random;
    }

    public double getStart(int dim) {
        return this.start[dim];
    }

    public double getStep(int dim) {
        return this.step[dim];
    }

    public double getStop(int dim) {
        return this.stop[dim];
    }

    public int getDimensions() {
        return this.start.length;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.start.length; ++i) {
            s.append(this.start[i]);
            s.append("\n");
            s.append(this.step[i]);
            s.append("\n");
            s.append(this.stop[i]);
            s.append("\n");
        }
        for (boolean b : this.random) {
            s.append(b + " ");
        }
        return s.toString();
    }

    public double getStep() {
        return this.getStep(0);
    }

    public double getStop() {
        return this.getStop(0);
    }

    public double getStart() {
        return this.getStart(0);
    }
}

