/*
 * Decompiled with CFR 0.152.
 */
package FitnessEvaluation.externalInterpreters.SymbolicRegression;

import FitnessEvaluation.InterpretedJScheme;
import FitnessEvaluation.util.Range;
import Individuals.Phenotype;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import java.util.Properties;

public class SymbolicRegressionJScheme
extends InterpretedJScheme
implements Stochastic {
    RandomNumberGenerator rng;
    private Range sr_range = new Range("rnd(-1, 20, 1)");
    private String sr_target = "(+ (+ (+ (+ x0 (* x0 x0)) (* x0 (* x0 x0))) (* (* x0 x0) (* x0 x0))) (* (* x0 x0) (* x0 (* x0 x0))))";
    private static final String SQUARE = "(define square (lambda (x) (* x x)))";
    private static final String PROTECTED_DIVISION = "(define d (lambda (t n) (if (= n 0) .0 (/ t n))))";
    private String target;
    private String tail;
    private String pre_statement;
    private String statement;
    private static final String POST_STATEMENT = ") )";
    private static final String RUN = "(run aim guess)";
    private String intervalS;

    @Override
    public void setProperties(Properties p) {
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    @Override
    public void setRNG(RandomNumberGenerator m) {
        this.rng = m;
    }

    public void setHead(Range range) {
        StringBuffer sb = new StringBuffer();
        double interval = range.getStop() - range.getStart();
        sb.append("(define inputs0 '(");
        int j = 0;
        while ((double)j < range.getStep()) {
            double d = this.rng.nextDouble();
            sb.append(range.getStart() + d * interval);
            if ((double)j < range.getStep() - 1.0) {
                sb.append(" ");
            }
            ++j;
        }
        sb.append("))");
        this.intervalS = sb.toString();
        sb = new StringBuffer();
        sb.append("(define aim (lambda (");
        sb.append("x0");
        sb.append(")");
        sb.append(this.sr_target);
        sb.append(POST_STATEMENT);
        this.target = sb.toString();
    }

    private void setTail(Range range, String s) {
        StringBuffer sb = new StringBuffer();
        double total_samples = range.getStep();
        sb.append("(define run (lambda (aim_x guess_x) ");
        sb.append("(do ((i 0 (+ 1 i)) ");
        sb.append("(diff 0) ");
        sb.append(")");
        sb.append(" ((= i " + total_samples + ")");
        sb.append(" diff)");
        sb.append("(set! diff (+ diff (square (abs (- (aim_x ");
        sb.append("(list-ref inputs0 i)");
        sb.append(") (guess_x ");
        sb.append("(list-ref inputs0 i)");
        sb.append(")");
        sb.append(")))))))");
        sb.append(" )");
        this.tail = sb.toString();
        StringBuffer guess = new StringBuffer();
        guess.append("(define guess (lambda (");
        guess.append("x0 ) ");
        this.pre_statement = guess.toString();
    }

    @Override
    public double runFile(Phenotype p) {
        double fit = 1.0E8;
        this.statement = p.getString();
        this.setHead(this.sr_range);
        this.setTail(this.sr_range, this.statement);
        this.statement = this.pre_statement + this.statement + POST_STATEMENT;
        try {
            this.js.eval(SQUARE);
            this.js.eval(PROTECTED_DIVISION);
            this.js.eval(this.intervalS);
            this.js.eval(this.target);
            this.js.eval(this.tail);
            this.js.eval(this.statement);
            Object res = this.js.eval(RUN);
            String sfit = res.toString();
            fit = new Double(sfit);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("woops! " + this.statement);
        }
        return fit;
    }
}

