/*
 * Decompiled with CFR 0.152.
 */
package FitnessEvaluation.SymbolicRegression;

import FitnessEvaluation.FitnessFunction;
import FitnessEvaluation.util.Range;
import Individuals.Individual;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import java.util.Properties;

public class SymbolicRegressionInterpreter
implements FitnessFunction,
Stochastic {
    RandomNumberGenerator rng;
    double[] x;
    double[] calculated_target;
    double[][] samples;
    String[] program;
    int programCounter;
    private Range range;

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public void calculateTarget(String target) {
        this.program = target.split(" ");
        this.calculated_target = new double[this.samples.length];
        int i = 0;
        while (i < this.samples.length) {
            for (int j = 0; j < this.x.length; ++j) {
                this.x[j] = this.samples[i][j];
            }
            this.programCounter = 0;
            int n = i++;
            this.calculated_target[n] = this.calculated_target[n] + this.run();
        }
    }

    @Override
    public void setProperties(Properties p) {
        System.out.println("Setting properties");
        if (p.getProperty("sr_range") == null) {
            System.out.println("SR_RANGE constant needs to be defined in the properties file");
        }
        this.range = new Range(p.getProperty("sr_range"), this.rng);
        this.x = new double[this.range.getDimensions()];
        this.samples = this.range.getSamples();
        this.calculateTarget(p.getProperty("sr_target"));
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    @Override
    public void setRNG(RandomNumberGenerator m) {
        this.rng = m;
    }

    @Override
    public void getFitness(Individual ind) {
        double fitness = 0.0;
        System.out.println("getting fitness");
        try {
            String phenotype = ind.getPhenotype().getString();
            System.out.println("PHEN" + phenotype);
            this.program = phenotype.split(" ");
            if (this.range != null && this.range.isRandom()) {
                this.samples = this.range.getSamples();
            }
            for (int i = 0; i < this.samples.length; ++i) {
                for (int j = 0; j < this.x.length; ++j) {
                    this.x[j] = this.samples[i][j];
                }
                this.programCounter = 0;
                double runValue = this.run();
                fitness += Math.pow(runValue - this.calculated_target[i], 2.0);
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(this.getClass().getName() + " Error getting fitness:" + e + "\n assigning DEFAULT");
            fitness = 1.0E8;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println(this.getClass().getName() + " Error getting fitness:" + e + "\n assigning DEFAULT");
            fitness = 1.0E8;
        }
        ind.getFitness().setDouble(fitness);
    }

    private double run() throws IllegalArgumentException {
        String s = this.program[this.programCounter];
        ++this.programCounter;
        if (s.equals("+")) {
            return this.run() + this.run();
        }
        if (s.equals("-")) {
            return this.run() - this.run();
        }
        if (s.equals("*")) {
            return this.run() * this.run();
        }
        if (s.equals("/")) {
            double numerator = this.run();
            double denominator = this.run();
            if (Math.abs(denominator) > 1.0E-5) {
                return numerator / denominator;
            }
            return numerator;
        }
        if (s.matches("x\\d+")) {
            int variableNumber = Integer.parseInt(s.substring(1));
            return this.x[variableNumber];
        }
        if (s.equals("rnd")) {
            return this.rng.nextDouble();
        }
        if (s.matches("-?\\d+\\.?\\d*")) {
            return Double.parseDouble(s);
        }
        throw new IllegalArgumentException(this.getClass().getName() + " Bad execution value:" + s);
    }

    @Override
    public boolean canCache() {
        return true;
    }

    public void setSamples(double[][] samples) {
        this.samples = samples;
    }

    public void setX(double[] x) {
        this.x = x;
    }
}

