/*
 * Decompiled with CFR 0.152.
 */
package FitnessEvaluation.Sudoku;

import FitnessEvaluation.FitnessFunction;
import Individuals.Individual;
import java.util.Properties;
import java.util.StringTokenizer;

public class SudokuFit
implements FitnessFunction {
    private static int size = 9;
    private static int subGrid = 3;
    private static int maxFit = 243;
    private static int[] solution = new int[81];
    private int[] match;

    @Override
    public void setProperties(Properties p) {
    }

    @Override
    public boolean canCache() {
        return true;
    }

    @Override
    public void getFitness(Individual i) {
        String p = i.getPhenotype().getString();
        this.parsePhen(p);
        double tempFit = this.evaluate(solution);
        double result = (double)maxFit - tempFit;
        i.getFitness().setDouble(result);
    }

    public void parsePhen(String p) {
        StringTokenizer tokenizer = new StringTokenizer(p);
        int cnt = 0;
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            SudokuFit.solution[cnt] = Integer.parseInt(tok);
            ++cnt;
        }
    }

    public double evaluate(int[] grid) {
        size = subGrid * subGrid;
        if (this.match == null) {
            this.match = new int[size + 1];
        }
        int tot = 0;
        for (int i = 0; i < size; ++i) {
            tot += this.checkLine(grid, i, size);
            tot += this.checkLine(grid, i * size, 1);
        }
        for (int x = 0; x < size; x += subGrid) {
            for (int y = 0; y < size; y += subGrid) {
                tot += this.checkBox(grid, x, y);
            }
        }
        return tot;
    }

    public int checkLine(int[] grid, int start, int diff) {
        int tot = 0;
        this.resetMatch();
        for (int i = 0; i < size; ++i) {
            int val = grid[start];
            if (this.match[val] == 0) {
                this.match[val] = 1;
                ++tot;
            }
            start += diff;
        }
        return tot;
    }

    public int checkBox(int[] grid, int x, int y) {
        int tot = 0;
        this.resetMatch();
        for (int i = x; i < x + subGrid; ++i) {
            for (int j = y; j < y + subGrid; ++j) {
                int val = grid[i + size * j];
                if (this.match[val] != 0) continue;
                this.match[val] = 1;
                ++tot;
            }
        }
        return tot;
    }

    public void resetMatch() {
        this.match[0] = 1;
        for (int i = 1; i < this.match.length; ++i) {
            this.match[i] = 0;
        }
    }
}

