/*
 * Decompiled with CFR 0.152.
 */
package FitnessEvaluation.SantaFeAntTrail;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class Trail {
    public static final int GRID_WIDTH = 32;
    public static final int GRID_HEIGHT = 32;
    public static final int EMPTY = 0;
    public static final int FOOD = 1;
    public static final int ANT = 8;
    public int _energy;
    public int _picked_up;
    public int[][] _trail = new int[][]{{0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    public int[][] _working_trail = new int[][]{{0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    public int food;
    public int _current_X;
    public int _current_Y;
    public int _facing_current_X;
    public int _facing_current_Y;

    public Trail() {
        this.initGEtrail(600);
    }

    public Trail(int energy) {
        this.initGEtrail(energy);
    }

    public int get_Energy() {
        return this._energy;
    }

    public boolean get_Energy_Left() {
        return this._energy > 0;
    }

    public int getFood() {
        return this.food;
    }

    public int get_Picked_Up() {
        return this._picked_up;
    }

    public double getFitness() {
        return this.getFood() - this.get_Picked_Up();
    }

    void initGEtrail(int e) {
        this._current_X = 0;
        this._current_Y = 0;
        this._facing_current_X = 0;
        this._facing_current_Y = 1;
        this._energy = e;
        this._picked_up = 0;
        this.food = 89;
    }

    void readTrailGEtrail(String file_name) {
        int x;
        int y = 0;
        int bufferSize = 1024;
        try {
            String line;
            FileReader fr = new FileReader(file_name);
            BufferedReader br = new BufferedReader(fr, bufferSize);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                for (x = 0; x < line.length(); ++x) {
                    char ch = line.charAt(x);
                    if (ch == '.' || ch == '0') {
                        this._trail[x][y] = 0;
                        this._working_trail[x][y] = 0;
                        continue;
                    }
                    if (ch != '1') continue;
                    this._trail[x][y] = 1;
                    this._working_trail[x][y] = 1;
                }
                ++y;
            }
            if (br != null) {
                br.close();
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found: " + file_name);
        }
        catch (IOException e) {
            System.err.println("IOException: " + file_name);
        }
        this.food = 0;
        for (y = 0; y < 32; ++y) {
            for (x = 0; x < 32; ++x) {
                if (this._trail[x][y] != 1) continue;
                ++this.food;
            }
        }
    }

    public void left() {
        if (this.get_Energy_Left()) {
            --this._energy;
            if (this._facing_current_Y < 0) {
                this._facing_current_X = this._current_X + 1;
                this._facing_current_Y = this._current_Y;
            } else if (this._facing_current_Y > 32) {
                this._facing_current_X = this._current_X - 1;
                this._facing_current_Y = this._current_Y;
            } else if (this._facing_current_X < 0) {
                this._facing_current_Y = this._current_Y - 1;
                this._facing_current_X = this._current_X;
            } else if (this._facing_current_X > 32) {
                this._facing_current_Y = this._current_Y + 1;
                this._facing_current_X = this._current_X;
            } else if (this._facing_current_Y < this._current_Y) {
                this._facing_current_X = this._current_X + 1;
                this._facing_current_Y = this._current_Y;
            } else if (this._facing_current_Y > this._current_Y) {
                this._facing_current_X = this._current_X - 1;
                this._facing_current_Y = this._current_Y;
            } else if (this._facing_current_X < this._current_X) {
                this._facing_current_X = this._current_X;
                this._facing_current_Y = this._current_Y - 1;
            } else if (this._facing_current_X > this._current_X) {
                this._facing_current_X = this._current_X;
                this._facing_current_Y = this._current_Y + 1;
            }
        }
    }

    public void right() {
        if (this.get_Energy_Left()) {
            --this._energy;
            if (this._facing_current_Y < 0) {
                this._facing_current_X = this._current_X - 1;
                this._facing_current_Y = this._current_Y;
            } else if (this._facing_current_Y > 32) {
                this._facing_current_X = this._current_X + 1;
                this._facing_current_Y = this._current_Y;
            } else if (this._facing_current_X < 0) {
                this._facing_current_Y = this._current_Y + 1;
                this._facing_current_X = this._current_X;
            } else if (this._facing_current_X > 32) {
                this._facing_current_Y = this._current_Y - 1;
                this._facing_current_X = this._current_X;
            } else if (this._facing_current_Y < this._current_Y) {
                this._facing_current_X = this._current_X - 1;
                this._facing_current_Y = this._current_Y;
            } else if (this._facing_current_Y > this._current_Y) {
                this._facing_current_X = this._current_X + 1;
                this._facing_current_Y = this._current_Y;
            } else if (this._facing_current_X < this._current_X) {
                this._facing_current_X = this._current_X;
                this._facing_current_Y = this._current_Y + 1;
            } else if (this._facing_current_X > this._current_X) {
                this._facing_current_X = this._current_X;
                this._facing_current_Y = this._current_Y - 1;
            }
        }
    }

    public void move() {
        if (this.get_Energy_Left()) {
            int old_current_X = this._current_X;
            int old_current_Y = this._current_Y;
            --this._energy;
            if (this._facing_current_X < 32 && this._facing_current_X >= 0 && this._facing_current_Y < 32 && this._facing_current_Y >= 0) {
                this._current_X = this._facing_current_X;
                this._current_Y = this._facing_current_Y;
                if (this._working_trail[this._current_X][this._current_Y] == 1) {
                    ++this._picked_up;
                    this._working_trail[this._current_X][this._current_Y] = 0;
                }
                if (old_current_X < this._current_X) {
                    this._facing_current_X = this._current_X + 1;
                    this._facing_current_Y = this._current_Y;
                }
                if (old_current_X > this._current_X) {
                    this._facing_current_X = this._current_X - 1;
                    this._facing_current_Y = this._current_Y;
                }
                if (old_current_Y < this._current_Y) {
                    this._facing_current_Y = this._current_Y + 1;
                    this._facing_current_X = this._current_X;
                }
                if (old_current_Y > this._current_Y) {
                    this._facing_current_Y = this._current_Y - 1;
                    this._facing_current_X = this._current_X;
                }
            } else {
                if (this._facing_current_X > 31) {
                    this._current_X = 0;
                    this._facing_current_X = 1;
                } else if (this._facing_current_X < 0) {
                    this._current_X = 31;
                    this._facing_current_X = 30;
                } else if (this._facing_current_Y > 31) {
                    this._current_Y = 0;
                    this._facing_current_Y = 1;
                } else if (this._facing_current_Y < 0) {
                    this._current_Y = 31;
                    this._facing_current_Y = 30;
                }
                if (this._working_trail[this._current_X][this._current_Y] == 1) {
                    ++this._picked_up;
                    this._working_trail[this._current_X][this._current_Y] = 0;
                }
            }
            this._working_trail[this._current_X][this._current_Y] = 8;
        }
    }

    public int food_ahead() {
        int is_there = 0;
        if (this._facing_current_X < 32 && this._facing_current_X >= 0 && this._facing_current_Y < 32 && this._facing_current_Y >= 0) {
            is_there = this._working_trail[this._facing_current_X][this._facing_current_Y] == 1 ? 1 : 0;
        } else if (this._facing_current_X > 31) {
            is_there = this._working_trail[0][this._current_Y] == 1 ? 1 : 0;
        } else if (this._facing_current_X < 0) {
            is_there = this._working_trail[31][this._current_Y] == 1 ? 1 : 0;
        } else if (this._facing_current_Y > 31) {
            is_there = this._working_trail[this._current_X][0] == 1 ? 1 : 0;
        } else if (this._facing_current_Y < 0) {
            is_there = this._working_trail[this._current_X][31] == 1 ? 1 : 0;
        }
        return is_there;
    }
}

