/*
 * Decompiled with CFR 0.152.
 */
package FitnessEvaluation.SantaFeAntTrail;

import FitnessEvaluation.FitnessFunction;
import FitnessEvaluation.SantaFeAntTrail.LosAltosTrail;
import FitnessEvaluation.SantaFeAntTrail.SanMateoTrail;
import FitnessEvaluation.SantaFeAntTrail.Trail;
import Individuals.Individual;
import Individuals.Phenotype;
import Mapper.Symbol;
import java.util.Properties;

public class SantaFeAntTrailInterpreter
implements FitnessFunction {
    private Phenotype phenotype;
    private int programCounter;
    private Trail trail;
    String trail_type;
    static final String IF = "if(food_ahead()==1) {";
    static final String ELSE = "} else {";
    static final String END_IF = "}";
    static final String MOVE = "move();";
    static final String LEFT = "left();";
    static final String RIGHT = "right();";
    static final String TRAIL_TYPE_FLAG = "trail_type";

    Trail getTrail(String trail_type) {
        Trail trailTmp;
        if (trail_type.equals("FitnessEvaluation.SantaFeAntTrail.Trail")) {
            trailTmp = new Trail();
        } else if (trail_type.equals("FitnessEvaluation.SantaFeAntTrail.SanMateoTrail")) {
            trailTmp = new SanMateoTrail();
        } else if (trail_type.equals("FitnessEvaluation.SantaFeAntTrail.LosAltosTrail")) {
            trailTmp = new LosAltosTrail();
        } else {
            throw new IllegalArgumentException("Unkown trail type:" + trail_type + "\n Specify using " + TRAIL_TYPE_FLAG + " e.g the basic Santa Fe Trail: " + TRAIL_TYPE_FLAG + " FitnessEvaluation.SantaFeAntTrail.Trail");
        }
        return trailTmp;
    }

    public void setTrail_type(String trail_type) {
        this.trail_type = trail_type;
    }

    @Override
    public void getFitness(Individual individual) {
        this.trail = this.getTrail(this.trail_type);
        double fitness = this.trail.getFood();
        try {
            this.phenotype = individual.getPhenotype();
            if (this.phenotype.size() > 0) {
                while (this.trail.get_Energy() > 0) {
                    this.programCounter = 0;
                    this.run();
                }
            } else {
                throw new IllegalArgumentException("Bad phenotype size");
            }
            fitness = this.trail.getFitness();
        }
        catch (IllegalArgumentException e) {
            System.err.println(this.getClass().getName() + " Error geting fitness:" + e + "\n assining DEFAULT");
            fitness = 1.0E8;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println(this.getClass().getName() + " Error geting fitness:" + e + "\n assining DEFAULT");
            fitness = 1.0E8;
        }
        individual.getFitness().setDouble(fitness);
    }

    @Override
    public boolean canCache() {
        return true;
    }

    @Override
    public void setProperties(Properties p) {
        this.trail_type = p.getProperty(TRAIL_TYPE_FLAG);
        if (this.trail_type == null) {
            throw new IllegalArgumentException("trail_type flag must be set in properties file");
        }
    }

    private void lookAheadElse() {
        boolean found = false;
        int depth = 0;
        while (this.phenotype.size() > this.programCounter && !found) {
            String token = ((Symbol)this.phenotype.get(this.programCounter)).getSymbolString();
            if (token.equals(ELSE) && depth == 0) {
                found = true;
            } else if (token.equals(IF)) {
                ++depth;
            } else if (token.equals(END_IF)) {
                --depth;
            }
            ++this.programCounter;
        }
    }

    private void lookAheadEnd_If() {
        boolean found = false;
        int depth = 0;
        while (this.phenotype.size() > this.programCounter && !found) {
            String token = ((Symbol)this.phenotype.get(this.programCounter)).getSymbolString();
            if (token.equals(END_IF)) {
                if (depth == 0) {
                    found = true;
                } else {
                    --depth;
                }
            } else if (token.equals(IF)) {
                ++depth;
            }
            ++this.programCounter;
        }
    }

    private void run() {
        if (this.programCounter < this.phenotype.size()) {
            String token = ((Symbol)this.phenotype.get(this.programCounter)).getSymbolString();
            ++this.programCounter;
            if (token.equals(IF)) {
                if (this.trail.food_ahead() != 1) {
                    this.lookAheadElse();
                }
            } else if (token.equals(LEFT)) {
                this.trail.left();
            } else if (token.equals(MOVE)) {
                this.trail.move();
            } else if (token.equals(RIGHT)) {
                this.trail.right();
            } else if (token.equals(ELSE)) {
                this.lookAheadEnd_If();
            } else if (!token.equals(END_IF)) {
                throw new IllegalArgumentException("Illegal Terminal symbol:" + token);
            }
            this.run();
        }
    }
}

