/*
 * Decompiled with CFR 0.152.
 */
package FitnessEvaluation.RoyalTree;

import FitnessEvaluation.FitnessFunction;
import Individuals.Individual;
import Individuals.Phenotype;
import Util.Structures.NimbleTree;
import Util.Structures.TreeNode;
import java.util.ArrayList;
import java.util.Properties;

public class RoyalTree
implements FitnessFunction {
    private ArrayList<String> alphabet = this.getAlphabet();
    private double completeBonus = 2.0;
    private double partialBonus = 1.0;
    private double fullBonus = 2.0;
    private double penalty = 0.3333333333333333;

    private ArrayList<String> getAlphabet() {
        ArrayList<String> alphabet = new ArrayList<String>();
        alphabet.add("x");
        alphabet.add("A");
        alphabet.add("B");
        alphabet.add("C");
        alphabet.add("D");
        alphabet.add("E");
        alphabet.add("F");
        alphabet.add("G");
        alphabet.add("H");
        return alphabet;
    }

    @Override
    public void setProperties(Properties p) {
    }

    public double evaluateString(Phenotype p) {
        return 1.0 / this.evaluate(p.getString());
    }

    public double evaluate(String s) {
        NimbleTree<String> tree = NimbleTree.makeTreeOverStringFromSExpression(s);
        return this.fitness(tree.getRoot());
    }

    private double fitness(TreeNode<String> node) {
        if (node.getData().equals(this.alphabet.get(0))) {
            return 1.0;
        }
        double retval = 0.0;
        boolean nodeIsPerfect = true;
        for (TreeNode treeNode : node) {
            if (this.isPerfect(node.getData(), treeNode)) {
                retval += this.fullBonus * this.fitness(treeNode);
                continue;
            }
            if (this.isSuccessor(node.getData(), (String)treeNode.getData())) {
                retval += this.partialBonus * this.fitness(treeNode);
                nodeIsPerfect = false;
                continue;
            }
            retval += this.penalty * this.fitness(treeNode);
            nodeIsPerfect = false;
        }
        if (nodeIsPerfect) {
            retval *= this.completeBonus;
        }
        return retval;
    }

    private boolean isSuccessor(String p, String q) {
        int pIdx = this.alphabet.indexOf(p);
        int qIdx = this.alphabet.indexOf(q);
        boolean retval = pIdx >= 0 && qIdx >= 0 && pIdx == qIdx + 1;
        return retval;
    }

    private boolean isPerfect(String current, TreeNode<String> child) {
        if (!this.isSuccessor(current, child.getData())) {
            return false;
        }
        for (TreeNode treeNode : child) {
            if (this.isPerfect(child.getData(), treeNode)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void getFitness(Individual i) {
        i.getFitness().setDouble(this.evaluateString(i.getPhenotype()));
    }

    @Override
    public boolean canCache() {
        return true;
    }

    public static void main(String[] args) {
        RoyalTree rt = new RoyalTree();
        double d = rt.evaluate(args[0]);
        System.out.println("fitness:" + d);
    }
}

