/*
 * Decompiled with CFR 0.152.
 */
package FitnessEvaluation.ParityProblem;

import FitnessEvaluation.FitnessFunction;
import Individuals.Individual;
import Individuals.Phenotype;
import Mapper.Symbol;
import Util.Structures.ReversePolish;
import java.util.Properties;

public class BooleanInterpreter
implements FitnessFunction {
    int programCounter;
    private static int[][] values;
    int size;
    private static int[] parities;
    private int counter;
    private static int[] currentValues;
    private Phenotype phenotype;
    private boolean infix;
    private ReversePolish revesePolish;

    public BooleanInterpreter() {
    }

    public BooleanInterpreter(Properties p) {
        this.setProperties(p);
    }

    public BooleanInterpreter(int size) {
        this.size = size;
        this.setParitiesArray(size);
        this.setParitiesValues(size - 1);
        this.setParities(size);
    }

    void setParitiesArray(int size) {
        values = new int[(int)Math.pow(2.0, size)][size];
        currentValues = new int[size];
        this.counter = 0;
    }

    @Override
    public void setProperties(Properties p) {
        this.size = Integer.parseInt(p.getProperty("parity_degree"));
        this.setParitiesArray(this.size);
        this.setParitiesValues(this.size - 1);
        this.setParities(this.size);
        this.infix = Boolean.parseBoolean(p.getProperty("infix_grammar"));
        if (this.infix) {
            this.revesePolish = new ReversePolish();
        }
    }

    public void setParitiesValues(int size) {
        for (int i = 0; i < 2; ++i) {
            BooleanInterpreter.currentValues[size] = i;
            if (size > 0) {
                this.setParitiesValues(size - 1);
                continue;
            }
            System.arraycopy(currentValues, 0, values[this.counter], 0, currentValues.length);
            ++this.counter;
        }
    }

    public void setParities(int size) {
        parities = new int[(int)Math.pow(2.0, size)];
        int i = 0;
        while ((double)i < Math.pow(2.0, size)) {
            BooleanInterpreter.parities[i] = Integer.bitCount(i) % 2;
            ++i;
        }
    }

    @Override
    public void getFitness(Individual ind) {
        double fitness = parities.length;
        try {
            this.phenotype = ind.getPhenotype();
            if (this.infix) {
                this.revesePolish.clear();
                this.phenotype = this.revesePolish.toPrefixPhenotype(this.phenotype);
            }
            this.counter = 0;
            while (this.counter < parities.length) {
                this.programCounter = 0;
                if (this.run() == parities[this.counter]) {
                    fitness -= 1.0;
                }
                ++this.counter;
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(this.getClass().getName() + " Error getting fitness:" + e + "\n assining DEFAULT");
            fitness = 1.0E8;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println(this.getClass().getName() + " Error getting fitness:" + e + "\n assining DEFAULT");
            fitness = 1.0E8;
        }
        ind.getFitness().setDouble(fitness);
    }

    public void setRevesePolish(ReversePolish revesePolish) {
        this.revesePolish = revesePolish;
    }

    public void setInfix(boolean infix) {
        this.infix = infix;
    }

    private int run() throws IllegalArgumentException {
        if (this.programCounter < this.phenotype.size()) {
            String s = ((Symbol)this.phenotype.get(this.programCounter)).getSymbolString();
            ++this.programCounter;
            if (s.equals("&")) {
                return this.run() & this.run();
            }
            if (s.equals("|")) {
                return this.run() | this.run();
            }
            if (s.equals("^")) {
                return this.run() ^ this.run();
            }
            if (s.equals("~") || s.equals("not")) {
                int value = this.run();
                value = value == 1 ? 0 : 1;
                return value;
            }
            if (s.matches("x\\d+") || s.matches("d\\d+")) {
                int variableNumber = Integer.parseInt(s.substring(1));
                return values[this.counter][variableNumber];
            }
            throw new IllegalArgumentException(this.getClass().getName() + " Bad execution value:" + s);
        }
        System.out.println("Prog counter 2: " + this.programCounter);
        throw new IllegalArgumentException(this.getClass().getName() + " No more code");
    }

    @Override
    public boolean canCache() {
        return true;
    }
}

