/*
 * Decompiled with CFR 0.152.
 */
package FitnessEvaluation.MaxProblem;

import Exceptions.BadParameterException;
import FitnessEvaluation.FitnessFunction;
import Individuals.Individual;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import java.util.Properties;

public class MaxProblemInterpreter
implements FitnessFunction,
Stochastic {
    RandomNumberGenerator rng;
    String[] program;
    int programCounter;
    int parseTreeDepth;
    int maxParseTreeDepth;
    int maxProblemDepth;
    double maxValue;

    @Override
    public void setProperties(Properties p) {
        try {
            this.maxProblemDepth = Integer.parseInt(p.getProperty("maxproblem_depth", "0"));
            if (this.maxProblemDepth < 3) {
                throw new BadParameterException("maxProblem depth was not specified in your properties file\n");
            }
        }
        catch (BadParameterException ex) {
            System.err.println(this.getClass().getName() + " " + ex + "The max problem depth was set to less than 3");
            ex.printStackTrace();
            System.exit(1);
        }
        this.setMaxValue();
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    @Override
    public void setRNG(RandomNumberGenerator m) {
        this.rng = m;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void getFitness(Individual ind) {
        double fitness = 0.0;
        String phenotype = ind.getPhenotype().getString();
        this.program = phenotype.split(" ");
        this.programCounter = 0;
        this.parseTreeDepth = 0;
        this.maxParseTreeDepth = 0;
        double runValue = this.run();
        fitness = this.getMaxValue() - runValue;
        if (this.maxParseTreeDepth > this.maxProblemDepth) {
            ind.getFitness().setDouble(1.0E8);
        } else {
            ind.getFitness().setDouble(fitness);
        }
    }

    private double run() throws IllegalArgumentException {
        String s = this.program[this.programCounter];
        ++this.programCounter;
        if (this.parseTreeDepth > this.maxParseTreeDepth) {
            this.maxParseTreeDepth = this.parseTreeDepth;
        }
        if (s.equals("+")) {
            ++this.parseTreeDepth;
            double value = this.run() + this.run();
            --this.parseTreeDepth;
            return value;
        }
        if (s.equals("-")) {
            ++this.parseTreeDepth;
            double value = this.run() - this.run();
            --this.parseTreeDepth;
            return value;
        }
        if (s.equals("*")) {
            ++this.parseTreeDepth;
            double value = this.run() * this.run();
            --this.parseTreeDepth;
            return value;
        }
        if (s.equals("/")) {
            double numerator = this.run();
            double denominator = this.run();
            if (Math.abs(denominator) > 1.0E-5) {
                return numerator / denominator;
            }
            return numerator;
        }
        if (s.equals("rnd")) {
            return this.rng.nextDouble();
        }
        if (s.matches("-?\\d+\\.?\\d*")) {
            return Double.parseDouble(s);
        }
        throw new IllegalArgumentException(this.getClass().getName() + " Bad execution value:" + s);
    }

    @Override
    public boolean canCache() {
        return true;
    }

    public void setMaxProblemDepth(int maxProblemDepth) {
        this.maxProblemDepth = maxProblemDepth;
    }

    public void setMaxValue() {
        this.maxValue = Math.pow(4.0, Math.pow(2.0, this.maxProblemDepth - 3));
        System.out.println(this.maxValue);
    }
}

