/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jsint.BacktraceException;
import jsint.E;
import jsint.Import;
import jsint.Pair;
import jsint.U;

public class Invoke {
    public static final int BUCKET_SIZE = 2;
    public static final Hashtable constructorCache = new Hashtable(50);
    public static final Hashtable constructorCachePriv = new Hashtable(50);
    public static final Hashtable staticCache = new Hashtable(50);
    public static final Hashtable instanceCache = new Hashtable(100);
    static final boolean ALLOW_PRIVATE_ACCESS = true;
    private static boolean CAN_GET_DECLARED_METHODS = Invoke.canGetDeclaredMethods();
    static Method SETACCESSIBLE = Invoke.getSetAccessibleMethod();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$jsint$Invoke;

    public static Object peek(Object target, String name) {
        return Invoke.peek0(target.getClass(), name, target);
    }

    public static Object peekStatic(Class c, String name) {
        return Invoke.peek0(c, name, c);
    }

    private static Object peek0(Class c, String name, Object target) {
        try {
            return c.getField(name).get(target);
        }
        catch (NoSuchFieldException e) {
            return E.error(target + " has no field named " + name);
        }
        catch (IllegalAccessException e) {
            return E.error("Can't access the " + name + " field of " + target);
        }
    }

    public static Object poke(Object target, String name, Object value) {
        return Invoke.poke0(target.getClass(), name, target, value);
    }

    public static Object pokeStatic(Class c, String name, Object value) {
        return Invoke.poke0(c, name, c, value);
    }

    private static Object poke0(Class c, String name, Object target, Object value) {
        try {
            c.getField(name).set(target, value);
            return value;
        }
        catch (NoSuchFieldException e) {
            return E.error(target + " has no field named " + name);
        }
        catch (IllegalAccessException e) {
            return E.error("Can't access the " + name + " field of " + target);
        }
    }

    public static Object invokeConstructor(String c, Object[] args) {
        Object[] ms = Invoke.constructorTable(c, false);
        return Invoke.invokeRawConstructor((Constructor)Invoke.findMethod(ms, args), args);
    }

    public static Object invokeRawConstructor(Constructor m, Object[] args) {
        try {
            return m.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw new BacktraceException(e.getTargetException(), new Object[]{m, args});
        }
        catch (InstantiationException e) {
            return E.error("Error during instantiation: ", U.list(e, m, args));
        }
        catch (IllegalAccessException e) {
            return E.error("Bad constructor application:", U.list(e, m, args));
        }
    }

    public static Object invokeStatic(Class c, String name, Object[] args) {
        return Invoke.invokeMethod(c, c, name, args, true, false);
    }

    public static Object invokeInstance(Object target, String name, Object[] args, boolean isPrivileged) {
        return Invoke.invokeMethod(target.getClass(), target, name, args, false, isPrivileged);
    }

    public static Object invokeMethod(Class c, Object target, String name, Object[] args, boolean isStatic, boolean isPrivileged) {
        Object[] ms = Invoke.methodTable(c, name, isStatic, isPrivileged);
        return Invoke.invokeRawMethod((Method)Invoke.findMethod(ms, args), target, args);
    }

    public static Object invokeRawMethod(Method m, Object target, Object[] args) {
        try {
            return m.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw new BacktraceException(e.getTargetException(), new Object[]{m, target, args});
        }
        catch (IllegalAccessException e) {
            return E.error("Bad method application from a private class: ", U.list(e, m, args));
        }
        catch (IllegalArgumentException e) {
            if (args == null) {
                return E.error(e + "\n " + m.toString() + "\n called with target: " + U.stringify(target) + " and a null argument vector.");
            }
            return E.error(e + "\nARGUMENT MISMATCH for method \n\n  " + m.toString() + "\n called with " + U.vectorToList(args));
        }
    }

    public static Object[] constructorTable(String c, boolean isPrivileged) {
        if (isPrivileged) {
            return Invoke.constructorTable0Priv(c);
        }
        return Invoke.constructorTable0(c);
    }

    public static Object[] constructorTable0Priv(String c) {
        Object[] result = (Object[])constructorCachePriv.get(c);
        if (result == null) {
            try {
                result = Invoke.methodArray(Invoke.makeAccessible(Import.classNamed(c).getDeclaredConstructors()));
            }
            catch (Exception e) {
                result = Invoke.methodArray(Import.classNamed(c).getConstructors());
            }
            constructorCachePriv.put(c, result);
        }
        if (result.length == 0) {
            return (Object[])E.error("Constructor " + c + " has no methods.");
        }
        return result;
    }

    public static Object[] constructorTable0(String c) {
        Object[] result = (Object[])constructorCache.get(c);
        if (result == null) {
            result = Invoke.methodArray(Import.classNamed(c).getConstructors());
            constructorCache.put(c, result);
        }
        if (result.length == 0) {
            return (Object[])E.error("Constructor " + c + " has no methods.");
        }
        return result;
    }

    private static Hashtable getMethodCache(boolean isStatic) {
        return isStatic ? staticCache : instanceCache;
    }

    private static Hashtable getNameTable(Hashtable table, String name) {
        Hashtable nameTable = (Hashtable)table.get(name);
        if (nameTable != null) {
            return nameTable;
        }
        nameTable = new Hashtable(10);
        table.put(name, nameTable);
        return nameTable;
    }

    public static Hashtable getClassTable(String name, boolean isStatic) {
        return Invoke.getNameTable(Invoke.getMethodCache(isStatic), name);
    }

    public static Object[] getCachedMethodTable(Class c, String name, boolean isStatic) {
        return (Object[])Invoke.getNameTable(Invoke.getMethodCache(isStatic), name).get(c);
    }

    public static void putCachedMethodTable(Class c, String name, boolean isStatic, Object value) {
        Invoke.getNameTable(Invoke.getMethodCache(isStatic), name).put(c, value);
    }

    public static Object[] methodTable0(Class c, String name, boolean isStatic, boolean isPrivileged) {
        String internalName = isPrivileged ? name.concat("#") : name;
        Object[] result1 = Invoke.getCachedMethodTable(c, internalName, isStatic);
        if (result1 == null) {
            result1 = Invoke.methodTableLookup(c, name, isStatic, isPrivileged);
            Invoke.putCachedMethodTable(c, internalName, isStatic, result1);
        }
        return result1;
    }

    public static Object[] methodTable(Class c, String name, boolean isStatic, boolean isPrivileged) {
        Object[] result1 = Invoke.methodTable0(c, name, isStatic, isPrivileged);
        if (result1 == null || result1.length == 0) {
            if (isStatic) {
                return (Object[])E.error("ERROR: \nNO STATIC METHOD  OF TYPE  \n\n  (" + c.getName() + "." + name + " ...)");
            }
            return (Object[])E.error("ERROR: \nNO INSTANCE METHOD OF TYPE \n\n  (." + name + " " + c.getName() + " ...)");
        }
        return result1;
    }

    public static Object[] methodTableLookup(Class c, String name, boolean isStatic, boolean isPrivileged) {
        if (isStatic) {
            return Invoke.methodTableLookupStatic(c, name, isPrivileged);
        }
        return Invoke.methodTableLookupInstance(c, name, isPrivileged);
    }

    public static Object[] methodTableLookupStatic(Class c, String name, boolean isPrivileged) {
        Method[] ms = Invoke.getMethods(c, isPrivileged);
        Vector<Method> result = new Vector<Method>(ms.length);
        for (int i = 0; i < ms.length; ++i) {
            Method m = ms[i];
            if (!Modifier.isStatic(m.getModifiers()) || !m.getName().equals(name)) continue;
            result.addElement(m);
        }
        Object[] result1 = new Object[result.size()];
        result.copyInto(result1);
        return Invoke.methodArray(result1);
    }

    public static Object[] methodTableLookupInstance(Class c, String name) {
        return Invoke.methodTableLookupInstance(c, name, false);
    }

    public static Object[] methodTableLookupInstance(Class c, String name, boolean isPrivileged) {
        Vector result = Invoke.methodVector(c, name, isPrivileged);
        Object[] result1 = new Object[result.size()];
        result.copyInto(result1);
        return Invoke.methodArray(result1);
    }

    public static Vector methodVector(Class c, String name) {
        return Invoke.methodVector(c, name, false);
    }

    public static Vector methodVector(Class c, String name, boolean isPrivileged) {
        return Invoke.methodVectorMerge(c, name, new Vector(10), isPrivileged);
    }

    public static Vector methodVectorMerge(Class c, String name, Vector result) {
        return Invoke.methodVectorMerge(c, name, result, false);
    }

    public static Vector methodVectorMerge(Class c, String name, Vector result, boolean isPrivileged) {
        Class s = c.getSuperclass();
        if (s != null) {
            result = Invoke.methodVectorMerge(s, name, result, isPrivileged);
        }
        Class<?>[] is = c.getInterfaces();
        for (int i = 0; i < is.length; ++i) {
            result = Invoke.methodVectorMerge(is[i], name, result, isPrivileged);
        }
        Method[] ms = Invoke.getMethods(c, isPrivileged);
        for (int i = 0; i < ms.length; ++i) {
            Method m = ms[i];
            if (Modifier.isStatic(m.getModifiers()) || !isPrivileged && (!Modifier.isPublic(m.getModifiers()) || !Modifier.isPublic(m.getDeclaringClass().getModifiers())) || !m.getName().equals(name)) continue;
            Invoke.maybeAdd(result, m);
        }
        return result;
    }

    private static void maybeAdd(Vector result, Method m1) {
        for (int i = 0; i < result.size(); ++i) {
            Method m2 = (Method)result.elementAt(i);
            if (!Invoke.parameterTypesMatch(Invoke.getParameterTypes(m1), Invoke.getParameterTypes(m2))) continue;
            return;
        }
        result.addElement(m1);
    }

    private static Class[] getParameterTypes(Object m) {
        return m instanceof Method ? ((Method)m).getParameterTypes() : ((Constructor)m).getParameterTypes();
    }

    private static Object[] methodArray(Object[] v) {
        Object[] result = new Object[v.length * 2];
        for (int i = 0; i < v.length; ++i) {
            result[i * 2] = Invoke.getParameterTypes(v[i]);
            result[i * 2 + 1] = v[i];
        }
        return result;
    }

    public static boolean parameterTypesMatch(Class[] p1, Class[] p2) {
        if (p1.length == p2.length) {
            for (int i = 0; i < p1.length; ++i) {
                if (p1[i] == p2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Object findMethod(Object[] methods, Object[] args) {
        if (methods.length == 2) {
            return methods[1];
        }
        return Invoke.findMethodNoOpt(methods, args);
    }

    static Object findMethodNoOpt(Object[] methods, Object[] args) {
        int best = -1;
        for (int m1 = 0; m1 < methods.length; m1 += 2) {
            Class[] p1 = (Class[])methods[m1];
            if (!Invoke.isApplicable(p1, args) || best != -1 && Invoke.moreApplicable((Class[])methods[best], p1)) continue;
            best = m1;
        }
        if (best != -1) {
            return methods[best + 1];
        }
        StringBuffer alts = new StringBuffer();
        for (int m1 = 0; m1 < methods.length; m1 += 2) {
            if (methods[m1 + 1] instanceof Member) {
                alts.append("   * " + methods[m1 + 1] + "\n");
                continue;
            }
            Class[] ts = (Class[])methods[m1];
            alts.append("   * " + methods[m1 + 1] + " ( ");
            for (int i = 0; i < ts.length; ++i) {
                alts.append(ts[i] + " ");
            }
            alts.append(")\n");
        }
        StringBuffer argtypes = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                argtypes.append(" ? ");
                continue;
            }
            argtypes.append(" " + args[i].getClass() + " ");
        }
        return E.error("\n\nERROR: NO " + (methods[1] instanceof Member ? (methods[1] instanceof Method ? "METHOD" : "CONSTRUCTOR") : "PROCEDURE") + " WITH NAME\n    " + (methods[1] instanceof Member ? ((Member)methods[1]).getName() : "?") + "\n and args\n     " + U.vectorToList(args) + "\n of types \n    " + argtypes.toString() + "\n\n possible alternatives are :\n" + alts.toString() + "\n\n");
    }

    public static boolean isApplicable(Class[] types, Object[] args) {
        if (types.length == args.length) {
            for (int i = 0; i < args.length; ++i) {
                if (Invoke.isArgApplicable(types[i], args[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isArgApplicable(Class p, Object a) {
        return a == null && (class$java$lang$Object == null ? (class$java$lang$Object = Invoke.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(p) || p.isInstance(a) || p.isPrimitive() && Invoke.primitiveWrapperType(p).isInstance(a);
    }

    private static Class primitiveWrapperType(Class p) {
        Class clazz = p == Byte.TYPE ? (class$java$lang$Byte == null ? (class$java$lang$Byte = Invoke.class$("java.lang.Byte")) : class$java$lang$Byte) : (p == Long.TYPE ? (class$java$lang$Long == null ? (class$java$lang$Long = Invoke.class$("java.lang.Long")) : class$java$lang$Long) : (p == Float.TYPE ? (class$java$lang$Float == null ? (class$java$lang$Float = Invoke.class$("java.lang.Float")) : class$java$lang$Float) : (p == Short.TYPE ? (class$java$lang$Short == null ? (class$java$lang$Short = Invoke.class$("java.lang.Short")) : class$java$lang$Short) : (p == Double.TYPE ? (class$java$lang$Double == null ? (class$java$lang$Double = Invoke.class$("java.lang.Double")) : class$java$lang$Double) : (p == Boolean.TYPE ? (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Invoke.class$("java.lang.Boolean")) : class$java$lang$Boolean) : (p == Integer.TYPE ? (class$java$lang$Integer == null ? (class$java$lang$Integer = Invoke.class$("java.lang.Integer")) : class$java$lang$Integer) : (p == Character.TYPE ? (class$java$lang$Character == null ? (class$java$lang$Character = Invoke.class$("java.lang.Character")) : class$java$lang$Character) : (Class)E.error("unknow primitive type: ", p))))))));
        return clazz;
    }

    private static boolean moreApplicable(Class[] p1, Class[] p2) {
        for (int i = 0; i < p1.length; ++i) {
            if (p2[i].isAssignableFrom(p1[i])) continue;
            return false;
        }
        return true;
    }

    public static Method findMethod(String name, Object target, Pair types) {
        try {
            return U.toClass(target).getMethod(name, Invoke.toClassArray(types, 0));
        }
        catch (NoSuchMethodException e) {
            return (Method)E.error("No method: ", U.list(name, target, types));
        }
    }

    public static Constructor findConstructor(Object target, Pair types) {
        try {
            return U.toClass(target).getConstructor(Invoke.toClassArray(types, 0));
        }
        catch (NoSuchMethodException e) {
            return (Constructor)E.error("No constructor: ", U.list(target, types));
        }
    }

    public static Class[] toClassArray(Pair types, int n) {
        if (types == Pair.EMPTY) {
            return new Class[n];
        }
        Class[] cs = Invoke.toClassArray((Pair)types.rest, n + 1);
        cs[n] = U.toClass(types.first);
        return cs;
    }

    public static Method[] getMethods(Class c, boolean isPrivileged) {
        Method[] methods = Invoke.getAllMethods(c, isPrivileged);
        return methods == null ? c.getMethods() : methods;
    }

    private static Method[] getAllMethods(Class c) {
        return Invoke.getAllMethods(c, false);
    }

    private static Method[] getAllMethods(Class c, boolean isPrivileged) {
        if (isPrivileged) {
            try {
                return (Method[])Invoke.makeAccessible(Invoke.getAllMethods0(c));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static boolean canGetDeclaredMethods() {
        try {
            (class$jsint$Invoke == null ? (class$jsint$Invoke = Invoke.class$("jsint.Invoke")) : class$jsint$Invoke).getDeclaredMethods();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Method[] getAllMethods0(Class c) {
        if (CAN_GET_DECLARED_METHODS) {
            Hashtable table = new Hashtable(35);
            Invoke.collectDeclaredMethods(c, table);
            Enumeration e = table.elements();
            Method[] ms = new Method[table.size()];
            int i = 0;
            while (e.hasMoreElements()) {
                ms[i] = (Method)e.nextElement();
                ++i;
            }
            return ms;
        }
        return null;
    }

    private static void collectDeclaredMethods(Class c, Hashtable h) {
        Method[] ms = c.getDeclaredMethods();
        for (int i = 0; i < ms.length; ++i) {
            h.put(ms[i], ms[i]);
        }
        Class<?>[] is = c.getInterfaces();
        for (int j = 0; j < is.length; ++j) {
            Invoke.collectDeclaredMethods(is[j], h);
        }
        Class sup = c.getSuperclass();
        if (sup != null) {
            Invoke.collectDeclaredMethods(sup, h);
        }
    }

    private static Method getSetAccessibleMethod() {
        try {
            Class<?> c = Class.forName("java.lang.reflect.AccessibleObject");
            Class<?> ca = Class.forName("[Ljava.lang.reflect.AccessibleObject;");
            return c.getMethod("setAccessible", ca, Boolean.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    static Object[] makeAccessible(Object[] items) {
        if (items != null && SETACCESSIBLE != null) {
            try {
                SETACCESSIBLE.invoke(null, items, Boolean.TRUE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return items;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

