%% FITNESS_EVALUATION_METHOD
function [new_pop stats] = symbolic_regression_multicore_ff(xo_pop, ...
    settings, generation, param, stats)
% Calls the fitness function
% [NEW_POP FITNESS_STORE] = SYMBOLIC_REGRESSION_MULTICORE_FF(XO_POP,
% SETTINGS, CFG, INITIALISATION, GENERATION) Calls the fitness function and
% checks the fitness to see how many needs to be recalculated. Returns the
% new population, NEW_POP and the updated STATS.
%
%    XO_POP cell array of population to evaluate 
%    SETTINGS struct for MULTICORE settings 
%    GENERATION integer denoting the current generation
%    PARAM struct with parameters
%    STATS struct with run stats

new_pop = xo_pop;

fitness_evaluations = xo_pop;
invalid_fitness_evaluations = [];
sim_restart = 0;
new_pop = [];
%% Evaluate individuals until there are no invalids or the restart is 0,
%% since to begin with there are no invalids
while ~isempty(invalid_fitness_evaluations) || ...
        sim_restart == 0
    fprintf(param.FID,'%d %d %d %d\n', sim_restart, size(new_pop,1), ...
            size(fitness_evaluations,1), size(invalid_fitness_evaluations,1));
    if sim_restart > 0
        fitness_evaluations = invalid_fitness_evaluations;
        invalid_fitness_evaluations = [];
    end
    %% Parameters for the evaluation
    parameterCell = {};
    evaluated_individuals = []; %indecies for evaluated individuals
    for i = 1:size(fitness_evaluations,1) 
        expression = fitness_evaluations(i).OUTPUT_C;
        %% Check if expression is cached
        fitness_i = [];
        if ~isempty(stats.fitness_store)
            fs = stats.fitness_store(:);
            fitness_i = find(strcmp(fs(1:2:end), expression));
        end
        if ~isempty(fitness_i)
            fitness_evaluations(i).FITNESS_C = fitness_i;
            new_pop = [new_pop; fitness_evaluations(i,:)];
        else
            parameterCell = [parameterCell {{expression, param}}];
            evaluated_individuals = [evaluated_individuals; i];
        end
    end
    %% Starting the multicore master and distributing the evaluations
    resultCell = startmulticoremaster(@srm_w, ...
                                      parameterCell, settings);    
    %% Validate the fitness values
    for i = 1:1:size(resultCell,2)
        item = resultCell{i}{1};
        is_nan = resultCell{i}{2};
        ind_index = evaluated_individuals(i);
        %% Dissallow NaN
        if is_nan && sim_restart < param.MAX_SIMULATION_RESTARTS
            
        end
        if is_nan
            if sim_restart < param.MAX_SIMULATION_RESTARTS
                invalid_fitness_evaluations = [invalid_fitness_evaluations ...
                                    fitness_evaluations(ind_index)];
            else
                fprintf(param.FID,'WARNING fitness_evaluation_method %d MAX SIMULATION RESTARTS: %s\n',generation, item.expression);
                fitness_evaluations(ind_index).FITNESS_C = item.fitness;
                new_pop = [new_pop; fitness_evaluations(ind_index)];
            end
        else
            stats.fitness_store = [stats.fitness_store struct2cell(item)];
            fitness_evaluations(ind_index).FITNESS_C = item.fitness;
            new_pop = [new_pop; fitness_evaluations(ind_index)];
        end
    end
    sim_restart = sim_restart + 1;
end

function values = srm_w(expression, param)
% Fitness is mean squared error
x = param.x;
target = param.target;

item.expression = expression;
try
    item.fitness = mean((eval(item.expression)-target).^2);
catch,
    disp(item.expression);
    disp(lasterror);
    item.fitness = param.MIN_FITNESS;
end
values = {item isnan(item.fitness)};
