function param = symbolic_regression_config(param)
% Configurations for symbolic regression problem
% PARAM = SYMBOLIC_REGRESSION(PARAM) configurations for symbolic regression
% problem. Sets and returns the problem dependent PARAMs
% PARAM struct with parameters
    

param.ORDER = 'ascend';
param.MAX_WRAPS = 2;
param.CODON_SIZE = 128;
param.POPULATION_SIZE = 100;
param.INITIAL_CHROMOSOME_SIZE = 200;
param.GENERATIONS = 50;
param.TOURNAMENT_SIZE = 2;
param.CROSSOVER_PROBABILITY = 0.7;
param.CROSSOVER_OPERATION = @single_point_crossover;
param.MUTATION_PROBABILITY = 0.05;
param.MUTATION_OPERATION = @uniform_integer_mutation;
param.EXTENDED_NODAL_PROBABILITY = 0.5;
param.EXTENDED_NODAL_TRIES = 1000;
param.ELITE_SIZE = 2;
param.PARISIMONY_PREASSURE = 1;
param.MAX_DEPTH = 5;
param.GROW_PROBABILITY = 0.5;
param.TAIL_SIZE = 1.0;
param.FEVALS_TIMES_SINGLE = 10 * 60;
param.NEVALS_AT_ONCE = 1;
param.SAVE_POPULATION = 'test_population_save.dat';
param.INITIALISATION = @uniform_initialisation;
param.SELECTION = @tournament_selection;
param.REPLACEMENT = @generational_replacement;
param.MIN_FITNESS = -inf;
    
param.FITNESS_FUNCTIONS = 1;
% What the individuals looks like
param.INDIVIDUAL_STRUCT = struct('INPUT_C', [], 'OUTPUT_C', [], ...
                                 'FITNESS_C', [], 'USED_INPUT_C', [], ...
                                 'DEPTH_C', [], ...
                                 'PRODUCTION_CHOICE_IDS_C', []);
param.GRAMMAR_FILE = 'grammars/sr.bnf';
param.VALIDATE_INDIVIDUAL = @individual_validation;
param.FITNESS_EVALUATION_METHOD = @symbolic_regression_ff;
% 20 points [-1,1]
param.x = -1:0.1:1;

% Precalculating the target
x = param.x;
param.target = x + x.^2 + x.^3 + x.^4 + x.^5 + x.^6;
    