%% UNIFORM_INTEGER_MUTATION
function individual = uniform_integer_mutation(individual, param)
% Mutates an individual uniformly with uniform probability
    
% INDIVIDUAL = UNIFORM_INTEGER_MUTATION(INDIVIDUAL, PARAM) Mutates the
% INDIVIDUAL uniformly with uniform probability. Returns the modified
% INDIVIDUAL
%
%    INDIVIDUAL struct to mutate
%    PARAM struct with parameters

% Find which codons are mutated
c_chrom = individual.INPUT_C;
mut_v = find(param.MUTATION_PROBABILITY > rand(1,length(c_chrom)));
% Set new codon values
c_chrom(mut_v) = param.RANDINT(param.CODON_SIZE,1,length(mut_v));
individual.INPUT_C = c_chrom;