%% UNIFORM_INITIALISATION
function inputs = uniform_initialisation(size, param)
% Uniformly generate integer inputs   
% INPUTS = UNIFORM_INITIALISATION(SIZE, PARAM) Uniformly generates SIZE
% integer inputs. Returns the integer INPUTS.
%    
%    SIZE integer for the number of inputs to generate
%    PARAM struct with parameters
    
inputs = param.RANDINT(param.CODON_SIZE, size, param.INITIAL_CHROMOSOME_SIZE);
inputs = mat2cell(inputs, ones(size, 1), [param.INITIAL_CHROMOSOME_SIZE]);