%% TOURNAMENT_SELECTION_NSGA2
function new_pop = tournament_selection_nsga2(param, pop)
% Select a new population using a tournament based on rank
% NEW_POP = TOURNAMENT_SELECTION_NSGA2(PARAM, POP) creates NEW_POP by
% selecting param.TOURNAMENT_SIZE individuals from POP and adding the lowest
% rank individuals from that tournament to the new population. If rank is
% the same distance is the discriminator.
%
% PARAM parameters
% POP population to select from
    
% TODO disallow picking the same individual for a tournament

new_pop(1:size(pop),1) = pop(1);
for i = 1:1:size(pop,1)
    tournament = pop(param.RANDINT(size(pop,1),param.TOURNAMENT_SIZE,1),:);
    if param.PARISIMONY_PREASSURE
        %Sort by used input as well
        tournament_mat = [tournament.RANK_C; tournament.DISTANCE_C; ...
            tournament.USED_INPUT_C]';
        [tournament_mat index] = sortrows(tournament_mat, [1 2 3]);
    else
        tournament_mat = [tournament.RANK_C; tournament.DISTANCE_C]';
        [tournament_mat index] = sortrows(tournament_mat, [1 2]);
    end
    winner = tournament(index(1),:);
    new_pop(i) = winner;
end

