function new_pop = tournament_selection(param, pop)
% Select a new population by selecting individuals using a tournament
    
% NEW_POP = TOURNAMENT_SELECTION(PARAM, POP) creates NEW_POP by selecting
% param.TOURNAMENT_SIZE individuals from POP and adding the fittest
% individuals from that tournament to the new population
% PARAM parameters
% POP population to select from
    
% TODO disallow picking the same individual for a tournament
new_pop(1:size(pop),1) = pop(1);
for i = 1:1:size(pop,1)
    %Pick individuals for a tournament
    tournament = pop(param.RANDINT(size(pop,1),param.TOURNAMENT_SIZE,1),:);
    fitnesses = [tournament.FITNESS_C];
    [fitnesses fitness_index] = sort(fitnesses, 2, param.ORDER);
    tournament = tournament(fitness_index, :);
    %Add the winner of the tournament 
    winner = tournament(1,:);
    winner_fitness = winner.FITNESS_C;
    tournament_fitness = [tournament.FITNESS_C];
    % Parisimony preassure, if fitness is equal for the winner and other
    % tournament members shorter individuals are preffered
    if param.PARISIMONY_PREASSURE ~= 0
        % Find the individuals who have the same fitness as the winner
        equal_fitnesses = tournament(find(tournament_fitness == winner_fitness),:);
        if size(equal_fitnesses,1) > 1 
            used_inputs = [equal_fitnesses.USED_INPUT_C];
            [used_inputs index] = sort(used_inputs, 2, 'ascend');
            equal_fitnesses = equal_fitnesses(index, :);
            winner = equal_fitnesses(1,:);
        end
    end
    new_pop(i) = winner;
end

