%% SINGLE_POINT_CROSSOVER
function xo_pop = single_point_crossover(new_pop, param)
% One crossover point is randomly picked for each parent. 
% XO_POP = SINGLE_POINT_CROSSOVER(NEW_POP, PARAM) One crossover point is
% randomly picked for each parent. The same individual can be
% picked. Returns XO_POP the crossed over individuals
%
%    NEW_POP - population to crossover
%    PARAM - struct with parameters
    
% TODO Uneven population sizes

xo_pop(1:size(new_pop),1) = new_pop(1);
for i = 1:2:size(new_pop, 1)
    % Pick parents
    parent_index = param.RANDINT(size(new_pop,1),1,2);
    parent1 = new_pop(parent_index(1)).INPUT_C;
    parent2 = new_pop(parent_index(2)).INPUT_C;
    is_crossed_over = (rand(1) < param.CROSSOVER_PROBABILITY);
    if is_crossed_over
        point1 = param.RANDINT(length(parent1),1,1);
        point2 = param.RANDINT(length(parent2),1,1);
        child1 = [parent1(1:point1) parent2(point2:end)];
        child2 = [parent2(1:point2) point1(point1:end)];
    else
        child1 = parent1;
        child2 = parent2;
    end
    % Create children
    children = [create_individual(child1, param); create_individual(child2,param)];        
    for j = 1:1:size(children,1)
        ind = children(j);
        if(param.IND_SIZE > 6)
            % If there is no crossover the mapping is still valid
            if is_crossed_over
                ind.PRODUCTION_CHOICE_IDS_C = [];
            else
                ind.USED_INPUT_C = new_pop(parent_index(j)).USED_INPUT_C;
                puids = new_pop(parent_index(j)).PRODUCTION_CHOICE_IDS_C;
                ind.PRODUCTION_CHOICE_IDS_C = puids;
            end
        end
        xo_pop(i+j-1) = ind;
    end
end
