function inputs = ramped_half_half_initialisation(size, param)
% Ramps the population to full depth or grow to maximum depth.

% INPUTS = RAMPED_HALF_HALF_INITIALISATION(SIZE, CFG) Rampes the population
% to be initialized to full depth or grow to maximum depth given the
% population size divided by the max depth. If SIZE is 1 the depth is
% chosen from the depth distribution of the first front. Tails are added
% according to the average of the input sizes.
% SIZE integer for the number of inputs to generate

% TODO better way of discriminating single initialisation call
    
max_depth_front_one = param.CFG.min_depth;
depths_front_one = [max_depth_front_one; 1];
inputs = {};

%% Checking the size of the inputs to initialize
if size > 1
    depth_population_size = ceil(size / (param.MAX_DEPTH - param.CFG.min_depth));
    if isinf(depth_population_size)
        depth_population_size = 1;
    end
    current_max_depth = param.CFG.min_depth;
    grow_probability = param.GROW_PROBABILITY;
else
    depth_population_size = 1;
    %%Uniformly pick a depth from the max of front one and min depth 
    depth_bin_cum = depths_front_one(2,:);
    edges = depths_front_one(1,:);
    r = param.RANDINT(max(depth_bin_cum),1,1);
    f = find(r<=depth_bin_cum);
    current_max_depth = edges(f(1));
    grow_probability = param.GROW_PROBABILITY;
end

while length(inputs) < size
    for i = 1:depth_population_size
        %% Full or Grow method
        if rand(1) < grow_probability
            inputs = [inputs; recursive_initialisation(0, param.CFG.s, {}, ...
                                                       [], current_max_depth, false, param)];
        else
            inputs = [inputs; recursive_initialisation(0, param.CFG.s, {}, ...
                                                       [], current_max_depth, true, param)];
        end
    end
    current_max_depth = current_max_depth + 1;
end
inputs = inputs(1:size,:);

%% Add tails
total_size = 0;
for i = 1:length(inputs)
    total_size = length(inputs{i});
end
average_size = total_size / length(inputs);
tail_size = ceil(average_size * param.TAIL_SIZE);
tails = param.RANDINT(param.CODON_SIZE, length(inputs), tail_size);
for i = 1:length(inputs)
    inputs{i,:} = [inputs{i,:}, tails(i,:)];
end

%% GET_RECURSIVE_PRODUCTION
function [chosen_production codon_value] = ...
        get_recursive_production(production_choices, chose_recursive, param)
% Chose a recursive or non-recursive production
    
% [CHOSEN_PRODUCTION CODON_VALUE] =
% GET_RECURSIVE_PRODUCTION(PRODUCTION_CHOICES, CHOSE_RECURSIVE, PARAM)
% Chose a recursive or non-recursive production from PRODUCTION_CHOICES
% in the CFG based on CHOSE_RECURSIVE. Returns the CHOSEN_PRODUCTION and
% a CODON_VALUE
% PRODUCTION_CHOICES cell array of the productions to chose between
% CHOSE_RECURSIVE boolean indicating if a recursive production should be
% chosen
    
%TODO imporve speed by only chosing from the recursive productions
    
MAX_INITIALISATION_CNT = 100; %Avoid infinite loop

initialisation_cnt = 1;
chosen_production_recursive = ~chose_recursive;

while chosen_production_recursive ~= chose_recursive && initialisation_cnt < MAX_INITIALISATION_CNT
    codon_value = param.RANDINT(param.CODON_SIZE, 1, 1);
    chosen_production = mod(codon_value, length(production_choices)) + 1;
    chosen_production_symbols = production_choices{chosen_production};
    has_recursive_symbol = false;
    i = 1;
    while ~has_recursive_symbol && i <= length(chosen_production_symbols)
        if any(strcmp(param.CFG.recursive_rules, chosen_production_symbols{i}))
            has_recursive_symbol = true;
        end
        i = i + 1;
    end
    chosen_production_recursive = has_recursive_symbol;
    initialisation_cnt = initialisation_cnt + 1;
end

%% RECURSIVE_INITIALISATION
function input = recursive_initialisation(depth, current_symbol, output, ...
    input, max_depth, full_initialisation, param)
% Grow a derivation till max_depth

% INPUT = RECURSIVE_INITIALISATION(DEPTH, CURRENT_SYMBOL, OUTPUT,
% INPUT, MAX_DEPTH, FULL_INITIALISATION, PARAM) Initialises an individual
% recursively using Full or Grow method. Returns the INPUT used for the
% initialisation.
    
% DEPTH integer the derivation tree depth 
% CURRENT_SYMBOL string of the symbol to be expanded
% OUTPUT cell string of the terminals of the collapsed derivation
% INPUT array of input used
% MAX_DEPTH integer for the max depth of the derivation tree
% FULL_INITIALISATION boolean for Full or Grow method
    
% TODO this will only grow using the first recursive production
    
if strncmp(current_symbol, '<', 1)
    index_NT = find(strcmp(param.CFG.s_NT, current_symbol));
    production_choices = param.CFG.rules{index_NT};
    current_rule = param.CFG.s_NT{index_NT};
    if any(strcmp(param.CFG.recursive_rules, current_rule))
        is_recursive_rule = true;
    else
        is_recursive_rule = false;
    end
    if depth >= max_depth
        %% Chose a non-recursive production
        [chosen_production_value codon_value] = ...
            get_recursive_production(production_choices, false, param);
    else
        %% Chose a production, with full it is recursive otherwise any
        %% production is chosen and if the current rule is recursive
        if full_initialisation && is_recursive_rule
            [chosen_production_value codon_value] = ...
                get_recursive_production(production_choices, true, param);
        else
            codon_value = param.RANDINT(param.CODON_SIZE, 1, 1);
            chosen_production_value = mod(codon_value, length(production_choices)) + 1;
        end
    end
    chosen_production = production_choices{chosen_production_value};
    %% Check if it is a determisnistic production, then use a codon
    if length(production_choices) > 1
        input = [input codon_value];
    end
    
    %% Expand the chosen productions
    for i = 1:length(chosen_production)
        depth = depth + 1;
        input = recursive_initialisation(depth, chosen_production{i}, ...
                                         output, input, max_depth, full_initialisation, param);
        depth = depth - 1;
    end
else
    %% Add terminal to the output
    output = {output{:} current_symbol};
end

