function individual = integer_extended_nodal_mutation(individual, param)
% Mutates the individuals n times on leafs or nodes
    
% INDIVIDUAL = INTEGER_EXTENDED_NODAL_MUTATION(INDIVIDUAL, PARAM) mutates
% the INDIVIDUAL PARAM.MUTATION_PROBABILITY times. With
% param.EXTENDED_NODAL_PROBABILITY and if the
% individual.PRODUCTION_CHOICE_IDS_C are still valid a non-subtree size
% altering mutation is performed. The structure param.CFG.conserving_rules
% keeps track of the non-subtree size changing mutations
    
c_used_input = individual.USED_INPUT_C;
c_chrom = individual.INPUT_C;
if isnan(individual.USED_INPUT_C)
    c_used_input = length(individual.INPUT_C);
end
mut_points = param.RANDINT(c_used_input,1,param.MUTATION_PROBABILITY);
% Use extended nodal mutation. Verify that mutpoints is not a modifying
% non-terminal
if rand(1) < param.EXTENDED_NODAL_PROBABILITY && ~isempty(individual.PRODUCTION_CHOICE_IDS_C)
    puids = individual.PRODUCTION_CHOICE_IDS_C;    
    % Avoid index out of range when full chromosome or wrapping is used
    mut_points = min([mut_points, length(individual.INPUT_C), size(puids,2)]);
    cnt = 1;
    while ~any(puids(mut_points) == param.CFG.conserving_rules) && cnt < param.EXTENDED_NODAL_TRIES
        mut_points = param.RANDINT(c_used_input,1,param.MUTATION_PROBABILITY);  
        mut_points = min([mut_points, length(individual.INPUT_C), size(puids,2)]);               
        cnt = cnt + 1;
    end
end
c_chrom(mut_points) = param.RANDINT(param.CODON_SIZE, 1, param.MUTATION_PROBABILITY);
individual.INPUT_C = c_chrom;
    