function pop = generational_replacement(pop, xo_pop, param)
% Replace the entire old population with the new population
    
% POP = GENERATIONAL_REPLACEMENT(POP, XO_POP, PARAM) replaces the entire POP with XO_POP. If
% param.ELITE_SIZE is greater then 0 then the best param.ELITE_SIZE
% individuals of POP replaces the worst in XO_POP
% POP old population
% XO_POP new population
% PARAM parameters
    
fitnesses = [pop.FITNESS_C];
[fitnesses fitness_index] = sort(fitnesses, 2, param.ORDER);
pop = pop(fitness_index, :);
elites = pop(1:param.ELITE_SIZE,:);
pop = [xo_pop(1:size(pop, 1) - param.ELITE_SIZE,:); elites];