function [new_pop stats] = multiobjective_function_ff(xo_pop, ...
    settings, generation, param, stats)
% Calls the fitness function
% [NEW_POP FITNESS_STORE] = MULTIOBJECTIVE_FUNCTION_FF(XO_POP, SETTINGS,
% CFG, INITIALISATION, GENERATION) Calls the fitness function and checks the
% fitness to see how many needs to be recalculated. Returns the new
% population, NEW_POP and the updated STATS. 
%
% The function is taken from
% Zitzler, E.; Deb, K. & Thiele, L. Comparison of multiobjective
% evolutionary algorithms: Empirical results Evolutionary computation, MIT
% Press, 2000, 8, 173-195
%
%    XO_POP cell array of population to evaluate 
%    SETTINGS struct for MULTICORE settings 
%    GENERATION integer denoting the current generation

new_pop = xo_pop;

for i = 1:size(new_pop,1) 
    item.expression = xo_pop(i).OUTPUT_C;    
    % Check if expression is cached
    fitness_i = [];
    if ~isempty(stats.fitness_store)
        fs = stats.fitness_store(:);
        fitness_i = find(strcmp(fs(1:2:end), item.expression));
    end
    if ~isempty(fitness_i)
        new_pop(i).FITNESS_C = fitness_i;
    else
        %%Eval gets the value of x
        eval(item.expression)
        m=30;
        f = x(1);
        g = 1 + (9 * sum(x(2:m)));
        h = (1 - sqrt(f/g));
        %% Stated as a minimization problem, but we maximize in GEM when
        %% using NSGA-II therefore multiply by -1
        item.fitness = -[f g*h];
        if any(isnan(item.fitness)) || any(isinf(item.fitness))
            item.fitness = [MIN_FITNESS MIN_FITNESS];
            fprintf(param.FID,'multiobjective_function_ff INF or NAN');
        end
        if any(size(item.fitness) ~= size(zeros(1,param.FITNESS_FUNCTIONS)))
            item.fitness = ones(1,param.FITNESS_FUNCTIONS) .* param.MIN_FITNESS
        end
        stats.fitness_store = [stats.fitness_store struct2cell(item)];
        new_pop(i).FITNESS_C = item.fitness;
    end
    %    fprintf(param.FID,'%d %.3f %.3f\n',i,new_pop(i).FITNESS_C);
    if any(size(new_pop(i).FITNESS_C) ~= size(zeros(1,param.FITNESS_FUNCTIONS)))
        item.fitness = ones(1,param.FITNESS_FUNCTIONS) .* param.MIN_FITNESS;
    end
    new_pop(i).FITNESS_C = item.fitness;
end

