function param = multiobjective_function_config(param)
% Configurations for multiobjective_function    
% PARAM = MULTIOBJECTIVE_FUNCTION_CONFIG(PARAM) configurations for
% multiobjective function. Returns PARAM parameters struct
%    PARAM struct of parameters

%%TODO change to minimization problem by ORDER and MIN_FITNESS    
param.ORDER = 'descend';
param.MAX_WRAPS = 2;
param.CODON_SIZE = 128;
param.POPULATION_SIZE = 40;
param.INITIAL_CHROMOSOME_SIZE = 200;
param.GENERATIONS = 20;
param.TOURNAMENT_SIZE = 2;
param.CROSSOVER_PROBABILITY = 0.5;
param.CROSSOVER_OPERATION = @single_point_crossover;
param.MUTATION_PROBABILITY = 0.1;
param.MUTATION_OPERATION = @uniform_integer_mutation;
param.EXTENDED_NODAL_PROBABILITY = 0.5;
param.EXTENDED_NODAL_TRIES = 1000;
param.ELITE_SIZE = 1;
param.PARISIMONY_PREASSURE = 1;
param.MAX_DEPTH = 5;
param.GROW_PROBABILITY = 0.5;
param.TAIL_SIZE = 1.0;
param.SAVE_POPULATION = 'test_population_save.dat';
param.INITIALISATION = @uniform_initialisation;
param.SELECTION = @tournament_selection_nsga2;
param.REPLACEMENT = @replacement_nsga2;
param.MIN_FITNESS = -inf;

param.FITNESS_EVALUATION_METHOD = @multiobjective_function_ff;
param.FITNESS_FUNCTIONS = 2;
param.GRAMMAR_FILE = 'grammars/sr_xy.bnf';
param.VALIDATE_INDIVIDUAL = @individual_validation;
%minimum fitness dependent on minimizing or maximization of the problem
%Individual data
param.INDIVIDUAL_STRUCT = struct('INPUT_C', [], 'OUTPUT_C', [], ...
                                 'FITNESS_C', [], 'USED_INPUT_C', ...
                                 [], 'RANK_C', [], ...
                                 'DISTANCE_C', [], 'DEPTH_C', [], ...
                                 'PRODUCTION_CHOICE_IDS_C', []);

% Fitness function is in multiobjective_function_ff
